/*
 * Decompiled with CFR 0.152.
 */
package oadd.net.hydromatic.avatica;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import oadd.net.hydromatic.avatica.BuiltInConnectionProperty;
import oadd.net.hydromatic.avatica.ConnectionConfig;
import oadd.net.hydromatic.avatica.ConnectionProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionConfigImpl
implements ConnectionConfig {
    protected final Properties properties;
    public static final Converter<Boolean> BOOLEAN_CONVERTER = new Converter<Boolean>(){

        @Override
        public Boolean apply(ConnectionProperty connectionProperty, String s) {
            if (s == null) {
                throw new RuntimeException("Required property '" + connectionProperty.camelName() + "' not specified");
            }
            return Boolean.parseBoolean(s);
        }
    };
    public static final Converter<String> IDENTITY_CONVERTER = new Converter<String>(){

        @Override
        public String apply(ConnectionProperty connectionProperty, String s) {
            return s;
        }
    };

    public ConnectionConfigImpl(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String schema() {
        return BuiltInConnectionProperty.SCHEMA.wrap(this.properties).getString();
    }

    @Override
    public String timeZone() {
        return BuiltInConnectionProperty.TIMEZONE.wrap(this.properties).getString();
    }

    public static Map<ConnectionProperty, String> parse(Properties properties, Map<String, ? extends ConnectionProperty> nameToProps) {
        LinkedHashMap<ConnectionProperty, String> map = new LinkedHashMap<ConnectionProperty, String>();
        for (String name : properties.stringPropertyNames()) {
            ConnectionProperty connectionProperty = nameToProps.get(name.toUpperCase());
            if (connectionProperty == null) continue;
            map.put(connectionProperty, properties.getProperty(name));
        }
        return map;
    }

    public static <E extends Enum> Converter<E> enumConverter(final Class<E> enumClass) {
        return new Converter<E>(){

            @Override
            public E apply(ConnectionProperty connectionProperty, String s) {
                if (s == null) {
                    throw new RuntimeException("Required property '" + connectionProperty.camelName() + "' not specified");
                }
                try {
                    return Enum.valueOf(enumClass, s);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Property '" + s + "' not valid for enum " + enumClass.getName());
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Converter<T> {
        public T apply(ConnectionProperty var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropEnv {
        final Map<? extends ConnectionProperty, String> map;
        private final ConnectionProperty property;

        public PropEnv(Map<? extends ConnectionProperty, String> map, ConnectionProperty property) {
            this.map = map;
            this.property = property;
        }

        private <T> T get_(Converter<T> converter, String defaultValue) {
            String s = this.map.get(this.property);
            if (s != null) {
                return converter.apply(this.property, s);
            }
            return converter.apply(this.property, defaultValue);
        }

        public String getString() {
            return this.getString((String)this.property.defaultValue());
        }

        public String getString(String defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.STRING);
            return this.get_(IDENTITY_CONVERTER, defaultValue);
        }

        public boolean getBoolean() {
            return this.getBoolean((Boolean)this.property.defaultValue());
        }

        public boolean getBoolean(boolean defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.BOOLEAN);
            return this.get_(BOOLEAN_CONVERTER, Boolean.toString(defaultValue));
        }

        public <E extends Enum<E>> E getEnum(Class<E> enumClass) {
            return (E)this.getEnum(enumClass, (Enum)this.property.defaultValue());
        }

        public <E extends Enum<E>> E getEnum(Class<E> enumClass, E defaultValue) {
            assert (this.property.type() == ConnectionProperty.Type.ENUM);
            return (E)((Enum)this.get_(ConnectionConfigImpl.enumConverter(enumClass), defaultValue.name()));
        }
    }
}

