/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.handler.codec.protobuf;

import oadd.com.google.protobuf.CodedOutputStream;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufOutputStream;
import oadd.io.netty.channel.ChannelHandler;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size(bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance(new ByteBufOutputStream(out), headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(msg, msg.readerIndex(), bodyLen);
    }
}

