/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.BeanProperty;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonMappingException;
import oadd.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class AtomicReferenceDeserializer
extends StdDeserializer<AtomicReference<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referencedType;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final JsonDeserializer<?> _valueDeserializer;

    public AtomicReferenceDeserializer(JavaType referencedType) {
        this(referencedType, null, null);
    }

    public AtomicReferenceDeserializer(JavaType referencedType, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(AtomicReference.class);
        this._referencedType = referencedType;
        this._valueDeserializer = deser;
        this._valueTypeDeserializer = typeDeser;
    }

    public AtomicReferenceDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (valueDeser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new AtomicReferenceDeserializer(this._referencedType, typeDeser, valueDeser);
    }

    @Override
    public AtomicReference<?> getNullValue(DeserializationContext ctxt) {
        return new AtomicReference();
    }

    @Override
    @Deprecated
    public AtomicReference<?> getNullValue() {
        return new AtomicReference();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        deser = deser == null ? ctxt.findContextualValueDeserializer(this._referencedType, property) : ctxt.handleSecondaryContextualization(deser, property, this._referencedType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(typeDeser, deser);
    }

    @Override
    public AtomicReference<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object contents = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        return new AtomicReference(contents);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue(ctxt);
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(p, ctxt);
        }
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }
}

