/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.hive.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.schema.DrillHiveTable;
import org.apache.drill.exec.store.hive.schema.DrillHiveViewTable;
import org.apache.drill.exec.store.hive.schema.HiveDatabaseSchema;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaFactory
implements SchemaFactory {
    static final Logger logger = LoggerFactory.getLogger(HiveSchemaFactory.class);
    private final DrillHiveMetaStoreClient processUserMetastoreClient;
    private final LoadingCache<String, DrillHiveMetaStoreClient> metaStoreClientLoadingCache;
    private final HiveStoragePlugin plugin;
    private final String schemaName;
    private final HiveConf hiveConf;
    private final boolean isDrillImpersonationEnabled;
    private final boolean isHS2DoAsSet;

    public HiveSchemaFactory(HiveStoragePlugin plugin, String name, final HiveConf hiveConf) throws ExecutionSetupException {
        this.schemaName = name;
        this.plugin = plugin;
        this.hiveConf = hiveConf;
        this.isHS2DoAsSet = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        this.isDrillImpersonationEnabled = plugin.getContext().getConfig().getBoolean("drill.exec.impersonation.enabled");
        try {
            this.processUserMetastoreClient = DrillHiveMetaStoreClient.createNonCloseableClientWithCaching(hiveConf);
        }
        catch (MetaException e) {
            throw new ExecutionSetupException("Failure setting up Hive metastore client.", (Throwable)e);
        }
        this.metaStoreClientLoadingCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(5L).removalListener((RemovalListener)new RemovalListener<String, DrillHiveMetaStoreClient>(){

            public void onRemoval(RemovalNotification<String, DrillHiveMetaStoreClient> notification) {
                DrillHiveMetaStoreClient client = (DrillHiveMetaStoreClient)((Object)notification.getValue());
                client.close();
            }
        }).build((CacheLoader)new CacheLoader<String, DrillHiveMetaStoreClient>(){

            public DrillHiveMetaStoreClient load(String userName) throws Exception {
                return DrillHiveMetaStoreClient.createClientWithAuthz(HiveSchemaFactory.this.processUserMetastoreClient, hiveConf, userName);
            }
        });
    }

    private boolean needToImpersonateReadingData() {
        return this.isDrillImpersonationEnabled && this.isHS2DoAsSet;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws IOException {
        DrillHiveMetaStoreClient mClientForSchemaTree = this.processUserMetastoreClient;
        if (this.isDrillImpersonationEnabled) {
            try {
                mClientForSchemaTree = (DrillHiveMetaStoreClient)((Object)this.metaStoreClientLoadingCache.get((Object)schemaConfig.getUserName()));
            }
            catch (ExecutionException e) {
                throw new IOException("Failure setting up Hive metastore client.", e);
            }
        }
        HiveSchema schema = new HiveSchema(schemaConfig, mClientForSchemaTree, this.schemaName);
        SchemaPlus hPlus = parent.add(this.schemaName, (Schema)schema);
        schema.setHolder(hPlus);
    }

    class HiveSchema
    extends AbstractSchema {
        private final SchemaConfig schemaConfig;
        private final DrillHiveMetaStoreClient mClient;
        private HiveDatabaseSchema defaultSchema;

        public HiveSchema(SchemaConfig schemaConfig, DrillHiveMetaStoreClient mClient, String name) {
            super((List)ImmutableList.of(), name);
            this.schemaConfig = schemaConfig;
            this.mClient = mClient;
            this.getSubSchema("default");
        }

        public AbstractSchema getSubSchema(String name) {
            try {
                List<String> dbs = this.mClient.getDatabases(this.schemaConfig.getIgnoreAuthErrors());
                if (!dbs.contains(name)) {
                    logger.debug("Database '{}' doesn't exists in Hive storage '{}'", (Object)name, (Object)HiveSchemaFactory.this.schemaName);
                    return null;
                }
                HiveDatabaseSchema schema = this.getSubSchemaKnownExists(name);
                if (name.equals("default")) {
                    this.defaultSchema = schema;
                }
                return schema;
            }
            catch (TException e) {
                logger.warn("Failure while attempting to access HiveDatabase '{}'.", (Object)name, (Object)e.getCause());
                return null;
            }
        }

        private HiveDatabaseSchema getSubSchemaKnownExists(String name) {
            HiveDatabaseSchema schema = new HiveDatabaseSchema(this, name, this.mClient, this.schemaConfig);
            return schema;
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                plusOfThis.add(s, (Schema)this.getSubSchemaKnownExists(s));
            }
        }

        public boolean showInInformationSchema() {
            return false;
        }

        public Set<String> getSubSchemaNames() {
            try {
                List<String> dbs = this.mClient.getDatabases(this.schemaConfig.getIgnoreAuthErrors());
                return Sets.newHashSet(dbs);
            }
            catch (TException e) {
                logger.warn("Failure while getting Hive database list.", (Throwable)e);
                return super.getSubSchemaNames();
            }
        }

        public Table getTable(String name) {
            if (this.defaultSchema == null) {
                return super.getTable(name);
            }
            return this.defaultSchema.getTable(name);
        }

        public Set<String> getTableNames() {
            if (this.defaultSchema == null) {
                return super.getTableNames();
            }
            return this.defaultSchema.getTableNames();
        }

        DrillTable getDrillTable(String dbName, String t) {
            String userToImpersonate;
            HiveReadEntry entry = this.getSelectionBaseOnName(dbName, t);
            if (entry == null) {
                return null;
            }
            String string = userToImpersonate = HiveSchemaFactory.this.needToImpersonateReadingData() ? this.schemaConfig.getUserName() : ImpersonationUtil.getProcessUserName();
            if (entry.getJdbcTableType() == Schema.TableType.VIEW) {
                return new DrillHiveViewTable(HiveSchemaFactory.this.schemaName, HiveSchemaFactory.this.plugin, userToImpersonate, entry);
            }
            return new DrillHiveTable(HiveSchemaFactory.this.schemaName, HiveSchemaFactory.this.plugin, userToImpersonate, entry);
        }

        HiveReadEntry getSelectionBaseOnName(String dbName, String t) {
            if (dbName == null) {
                dbName = "default";
            }
            try {
                return this.mClient.getHiveReadEntry(dbName, t, this.schemaConfig.getIgnoreAuthErrors());
            }
            catch (TException e) {
                logger.warn("Exception occurred while trying to read table. {}.{}", new Object[]{dbName, t, e.getCause()});
                return null;
            }
        }

        public AbstractSchema getDefaultSchema() {
            return this.defaultSchema;
        }

        public String getTypeName() {
            return "hive";
        }
    }
}

