/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hive-scan")
public class HiveScan
extends AbstractGroupScan {
    static final Logger logger = LoggerFactory.getLogger(HiveScan.class);
    private static int HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN = 20;
    @JsonProperty(value="hive-table")
    public HiveReadEntry hiveReadEntry;
    @JsonIgnore
    public HiveStoragePlugin storagePlugin;
    @JsonProperty(value="columns")
    public List<SchemaPath> columns;
    @JsonIgnore
    protected final HiveMetadataProvider metadataProvider;
    @JsonIgnore
    private List<List<HiveMetadataProvider.InputSplitWrapper>> mappings;
    @JsonIgnore
    protected List<HiveMetadataProvider.InputSplitWrapper> inputSplits;

    @JsonCreator
    public HiveScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="hive-table") HiveReadEntry hiveReadEntry, @JsonProperty(value="storage-plugin") String storagePluginName, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        this(userName, hiveReadEntry, (HiveStoragePlugin)pluginRegistry.getPlugin(storagePluginName), columns, null);
    }

    public HiveScan(String userName, HiveReadEntry hiveReadEntry, HiveStoragePlugin storagePlugin, List<SchemaPath> columns, HiveMetadataProvider metadataProvider) throws ExecutionSetupException {
        super(userName);
        this.hiveReadEntry = hiveReadEntry;
        this.columns = columns;
        this.storagePlugin = storagePlugin;
        this.metadataProvider = metadataProvider == null ? new HiveMetadataProvider(userName, hiveReadEntry, storagePlugin.getHiveConf()) : metadataProvider;
    }

    public HiveScan(HiveScan that) {
        super((AbstractGroupScan)that);
        this.columns = that.columns;
        this.hiveReadEntry = that.hiveReadEntry;
        this.storagePlugin = that.storagePlugin;
        this.metadataProvider = that.metadataProvider;
    }

    public HiveScan clone(HiveReadEntry hiveReadEntry) throws ExecutionSetupException {
        return new HiveScan(this.getUserName(), hiveReadEntry, this.storagePlugin, this.columns, this.metadataProvider);
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    protected List<HiveMetadataProvider.InputSplitWrapper> getInputSplits() {
        if (this.inputSplits == null) {
            this.inputSplits = this.metadataProvider.getInputSplits(this.hiveReadEntry);
        }
        return this.inputSplits;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.mappings = Lists.newArrayList();
        for (int i = 0; i < endpoints.size(); ++i) {
            this.mappings.add(new ArrayList());
        }
        int count = endpoints.size();
        List<HiveMetadataProvider.InputSplitWrapper> inputSplits = this.getInputSplits();
        for (int i = 0; i < inputSplits.size(); ++i) {
            this.mappings.get(i % count).add(inputSplits.get(i));
        }
    }

    public static String serializeInputSplit(InputSplit split) throws IOException {
        ByteArrayDataOutput byteArrayOutputStream = ByteStreams.newDataOutput();
        split.write((DataOutput)byteArrayOutputStream);
        String encoded = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
        logger.debug("Encoded split string for split {} : {}", (Object)split, (Object)encoded);
        return encoded;
    }

    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        try {
            List<HiveMetadataProvider.InputSplitWrapper> splits = this.mappings.get(minorFragmentId);
            ArrayList parts = Lists.newArrayList();
            ArrayList encodedInputSplits = Lists.newArrayList();
            ArrayList splitTypes = Lists.newArrayList();
            for (HiveMetadataProvider.InputSplitWrapper split : splits) {
                if (split.getPartition() != null) {
                    parts.add(new HiveTable.HivePartition(split.getPartition()));
                }
                encodedInputSplits.add(HiveScan.serializeInputSplit(split.getSplit()));
                splitTypes.add(split.getSplit().getClass().getName());
            }
            if (parts.size() <= 0) {
                parts = null;
            }
            HiveReadEntry subEntry = new HiveReadEntry(this.hiveReadEntry.table, parts);
            return new HiveSubScan(this.getUserName(), encodedInputSplits, subEntry, splitTypes, this.columns, this.storagePlugin);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int getMaxParallelizationWidth() {
        return this.getInputSplits().size();
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.storagePlugin.getContext().getBits()) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("endpoing address: {}", (Object)endpoint.getAddress());
        }
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = new HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity>();
        try {
            long totalSize = 0L;
            List<HiveMetadataProvider.InputSplitWrapper> inputSplits = this.getInputSplits();
            for (HiveMetadataProvider.InputSplitWrapper split : inputSplits) {
                totalSize += Math.max(1L, split.getSplit().getLength());
            }
            for (HiveMetadataProvider.InputSplitWrapper split : inputSplits) {
                float affinity = (float)Math.max(1L, split.getSplit().getLength()) / (float)totalSize;
                for (String loc : split.getSplit().getLocations()) {
                    logger.debug("split location: {}", (Object)loc);
                    CoordinationProtos.DrillbitEndpoint endpoint = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(loc);
                    if (endpoint == null) continue;
                    if (affinityMap.containsKey(endpoint)) {
                        ((EndpointAffinity)affinityMap.get(endpoint)).addAffinity((double)affinity);
                        continue;
                    }
                    affinityMap.put(endpoint, new EndpointAffinity(endpoint, (double)affinity));
                }
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
        for (CoordinationProtos.DrillbitEndpoint ep : affinityMap.keySet()) {
            Preconditions.checkNotNull((Object)ep);
        }
        for (EndpointAffinity a : affinityMap.values()) {
            Preconditions.checkNotNull((Object)a.getEndpoint());
        }
        return Lists.newArrayList(affinityMap.values());
    }

    public ScanStats getScanStats() {
        try {
            HiveMetadataProvider.HiveStats stats = this.metadataProvider.getStats(this.hiveReadEntry);
            logger.debug("HiveStats: {}", (Object)stats.toString());
            float cpuCost = 1 * this.getSerDeOverheadFactor();
            return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, stats.getNumRows(), cpuCost, (float)stats.getSizeInBytes());
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    protected int getSerDeOverheadFactor() {
        int projectedColumnCount;
        if (AbstractRecordReader.isStarQuery(this.columns)) {
            Table hiveTable = this.hiveReadEntry.getTable();
            projectedColumnCount = hiveTable.getSd().getColsSize() + hiveTable.getPartitionKeysSize();
        } else {
            projectedColumnCount = Math.max(this.columns.size(), 1);
        }
        return projectedColumnCount * HIVE_SERDE_SCAN_OVERHEAD_FACTOR_PER_COLUMN;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new HiveScan(this);
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        List<HiveTable.HivePartition> partitions = this.hiveReadEntry.getHivePartitionWrappers();
        int numPartitions = partitions == null ? 0 : partitions.size();
        return "HiveScan [table=" + this.hiveReadEntry.getHiveTableWrapper() + ", columns=" + this.columns + ", numPartitions=" + numPartitions + ", partitions= " + partitions + ", inputDirectories=" + this.metadataProvider.getInputDirectories(this.hiveReadEntry) + "]";
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HiveScan newScan = new HiveScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public boolean supportsPartitionFilterPushdown() {
        List partitionKeys = this.hiveReadEntry.getTable().getPartitionKeys();
        return partitionKeys != null && partitionKeys.size() != 0;
    }

    @JsonIgnore
    public HiveConf getHiveConf() {
        return this.storagePlugin.getHiveConf();
    }

    @JsonIgnore
    public boolean isNativeReader() {
        return false;
    }
}

