/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableDecimal18Vector;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.NullableDecimal38SparseVector;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class HiveFieldConverter {
    private static Map<PrimitiveObjectInspector.PrimitiveCategory, Class<? extends HiveFieldConverter>> primMap = Maps.newHashMap();

    public abstract void setSafeValue(ObjectInspector var1, Object var2, ValueVector var3, int var4);

    public static HiveFieldConverter create(TypeInfo typeInfo, FragmentContext fragmentContext) throws IllegalAccessException, InstantiationException {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory pCat = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                if (pCat != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
                    Class<? extends HiveFieldConverter> clazz = primMap.get(pCat);
                    if (clazz != null) {
                        return clazz.newInstance();
                    }
                } else {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                    int precision = decimalTypeInfo.precision();
                    int scale = decimalTypeInfo.scale();
                    if (precision <= 9) {
                        return new Decimal9(precision, scale);
                    }
                    if (precision <= 18) {
                        return new Decimal18(precision, scale);
                    }
                    if (precision <= 28) {
                        return new Decimal28(precision, scale, fragmentContext);
                    }
                    return new Decimal38(precision, scale, fragmentContext);
                }
                HiveUtilities.throwUnsupportedHiveDataTypeError(pCat.toString());
                break;
            }
            default: {
                HiveUtilities.throwUnsupportedHiveDataTypeError(typeInfo.getCategory().toString());
            }
        }
        return null;
    }

    static {
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.BINARY, Binary.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, Boolean.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.BYTE, Byte.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, Double.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, Float.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.INT, Int.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.LONG, Long.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.SHORT, Short.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.STRING, String.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, VarChar.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP, Timestamp.class);
        primMap.put(PrimitiveObjectInspector.PrimitiveCategory.DATE, Date.class);
    }

    public static class Date
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            java.sql.Date value = ((DateObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            DateTime date = new DateTime(value.getTime()).withZoneRetainFields(DateTimeZone.UTC);
            ((NullableDateVector)outputVV).getMutator().setSafe(outputIndex, date.getMillis());
        }
    }

    public static class Timestamp
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            java.sql.Timestamp value = ((TimestampObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            DateTime ts = new DateTime(value.getTime()).withZoneRetainFields(DateTimeZone.UTC);
            ((NullableTimeStampVector)outputVV).getMutator().setSafe(outputIndex, ts.getMillis());
        }
    }

    public static class VarChar
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            Text value = ((HiveVarcharObjectInspector)oi).getPrimitiveWritableObject(hiveFieldValue).getTextValue();
            byte[] valueBytes = value.getBytes();
            int valueLen = value.getLength();
            ((NullableVarCharVector)outputVV).getMutator().setSafe(outputIndex, valueBytes, 0, valueLen);
        }
    }

    public static class String
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            Text value = ((StringObjectInspector)oi).getPrimitiveWritableObject(hiveFieldValue);
            byte[] valueBytes = value.getBytes();
            int len = value.getLength();
            ((NullableVarCharVector)outputVV).getMutator().setSafe(outputIndex, valueBytes, 0, len);
        }
    }

    public static class Long
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            long value = (java.lang.Long)((LongObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableBigIntVector)outputVV).getMutator().setSafe(outputIndex, value);
        }
    }

    public static class Byte
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            byte value = (java.lang.Byte)((ByteObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableIntVector)outputVV).getMutator().setSafe(outputIndex, (int)value);
        }
    }

    public static class Short
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            short value = (java.lang.Short)((ShortObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableIntVector)outputVV).getMutator().setSafe(outputIndex, (int)value);
        }
    }

    public static class Int
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            int value = (Integer)((IntObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableIntVector)outputVV).getMutator().setSafe(outputIndex, value);
        }
    }

    public static class Float
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            float value = ((java.lang.Float)((FloatObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue)).floatValue();
            ((NullableFloat4Vector)outputVV).getMutator().setSafe(outputIndex, value);
        }
    }

    public static class Double
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            double value = (java.lang.Double)((DoubleObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableFloat8Vector)outputVV).getMutator().setSafe(outputIndex, value);
        }
    }

    public static class Decimal38
    extends HiveFieldConverter {
        private final Decimal38SparseHolder holder = new Decimal38SparseHolder();

        public Decimal38(int precision, int scale, FragmentContext context) {
            this.holder.scale = scale;
            this.holder.precision = precision;
            this.holder.buffer = context.getManagedBuffer(24);
            this.holder.start = 0;
        }

        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue).bigDecimalValue(), (ByteBuf)this.holder.buffer, (int)this.holder.start, (int)this.holder.scale, (int)this.holder.precision, (int)6);
            ((NullableDecimal38SparseVector)outputVV).getMutator().setSafe(outputIndex, this.holder);
        }
    }

    public static class Decimal28
    extends HiveFieldConverter {
        private final Decimal28SparseHolder holder = new Decimal28SparseHolder();

        public Decimal28(int precision, int scale, FragmentContext context) {
            this.holder.scale = scale;
            this.holder.precision = precision;
            this.holder.buffer = context.getManagedBuffer(20);
            this.holder.start = 0;
        }

        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            DecimalUtility.getSparseFromBigDecimal((BigDecimal)((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue).bigDecimalValue(), (ByteBuf)this.holder.buffer, (int)this.holder.start, (int)this.holder.scale, (int)this.holder.precision, (int)5);
            ((NullableDecimal28SparseVector)outputVV).getMutator().setSafe(outputIndex, this.holder);
        }
    }

    public static class Decimal18
    extends HiveFieldConverter {
        private final Decimal18Holder holder = new Decimal18Holder();

        public Decimal18(int precision, int scale) {
            this.holder.scale = scale;
            this.holder.precision = precision;
        }

        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            this.holder.value = DecimalUtility.getDecimal18FromBigDecimal((BigDecimal)((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue).bigDecimalValue(), (int)this.holder.scale, (int)this.holder.precision);
            ((NullableDecimal18Vector)outputVV).getMutator().setSafe(outputIndex, this.holder);
        }
    }

    public static class Decimal9
    extends HiveFieldConverter {
        private final Decimal9Holder holder = new Decimal9Holder();

        public Decimal9(int precision, int scale) {
            this.holder.scale = scale;
            this.holder.precision = precision;
        }

        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            this.holder.value = DecimalUtility.getDecimal9FromBigDecimal((BigDecimal)((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue).bigDecimalValue(), (int)this.holder.scale, (int)this.holder.precision);
            ((NullableDecimal9Vector)outputVV).getMutator().setSafe(outputIndex, this.holder);
        }
    }

    public static class Boolean
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            boolean value = (java.lang.Boolean)((BooleanObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableBitVector)outputVV).getMutator().setSafe(outputIndex, value ? 1 : 0);
        }
    }

    public static class Binary
    extends HiveFieldConverter {
        @Override
        public void setSafeValue(ObjectInspector oi, Object hiveFieldValue, ValueVector outputVV, int outputIndex) {
            byte[] value = ((BinaryObjectInspector)oi).getPrimitiveJavaObject(hiveFieldValue);
            ((NullableVarBinaryVector)outputVV).getMutator().setSafe(outputIndex, value, 0, value.length);
        }
    }
}

