/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetSubScan;
import org.apache.drill.exec.store.hive.HiveRecordReader;
import org.apache.drill.exec.store.parquet.ParquetDirectByteBufferAllocator;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;

public class HiveDrillNativeScanBatchCreator
implements BatchCreator<HiveDrillNativeParquetSubScan> {
    public ScanBatch getBatch(FragmentContext context, HiveDrillNativeParquetSubScan config, List<RecordBatch> children) throws ExecutionSetupException {
        Table table = config.getTable();
        List<InputSplit> splits = config.getInputSplits();
        List<Partition> partitions = config.getPartitions();
        ArrayList columns = config.getColumns();
        String partitionDesignator = context.getOptions().getOption((String)"drill.exec.storage.file.partition.column.label").string_val;
        boolean hasPartitions = partitions != null && partitions.size() > 0;
        ArrayList partitionColumns = Lists.newArrayList();
        ArrayList selectedPartitionColumns = Lists.newArrayList();
        ArrayList newColumns = columns;
        if (AbstractRecordReader.isStarQuery(columns)) {
            for (int i = 0; i < table.getPartitionKeys().size(); ++i) {
                selectedPartitionColumns.add(i);
            }
        } else {
            newColumns = Lists.newArrayList();
            Pattern pattern = Pattern.compile(String.format("%s[0-9]+", partitionDesignator));
            for (SchemaPath column : columns) {
                Matcher m = pattern.matcher(column.getAsUnescapedPath());
                if (m.matches()) {
                    selectedPartitionColumns.add(Integer.parseInt(column.getAsUnescapedPath().toString().substring(partitionDesignator.length())));
                    continue;
                }
                newColumns.add(column);
            }
        }
        OperatorContext oContext = context.newOperatorContext((PhysicalOperator)config);
        int currentPartitionIndex = 0;
        ArrayList readers = Lists.newArrayList();
        HiveConf conf = config.getHiveConf();
        HashMap footerCache = Maps.newHashMap();
        try {
            for (InputSplit split : splits) {
                FileSplit fileSplit = (FileSplit)split;
                Path finalPath = fileSplit.getPath();
                JobConf cloneJob = new ProjectionPusher().pushProjectionsAndFilters(new JobConf((Configuration)conf), finalPath.getParent());
                FileSystem fs = finalPath.getFileSystem((Configuration)cloneJob);
                ParquetMetadata parquetMetadata = (ParquetMetadata)footerCache.get(finalPath.toString());
                if (parquetMetadata == null) {
                    parquetMetadata = ParquetFileReader.readFooter((Configuration)cloneJob, (Path)finalPath);
                    footerCache.put(finalPath.toString(), parquetMetadata);
                }
                List<Integer> rowGroupNums = this.getRowGroupNumbersFromFileSplit(fileSplit, parquetMetadata);
                for (int rowGroupNum : rowGroupNums) {
                    readers.add(new ParquetRecordReader(context, Path.getPathWithoutSchemeAndAuthority((Path)finalPath).toString(), rowGroupNum, fs, CodecFactory.createDirectCodecFactory((Configuration)fs.getConf(), (ByteBufferAllocator)new ParquetDirectByteBufferAllocator(oContext.getAllocator()), (int)0), parquetMetadata, (List)newColumns));
                    if (!hasPartitions) continue;
                    Partition p = partitions.get(currentPartitionIndex);
                    partitionColumns.add(p.getValues().toArray(new String[0]));
                }
                ++currentPartitionIndex;
            }
        }
        catch (IOException | RuntimeException e) {
            AutoCloseables.close((Throwable)e, (Collection)readers);
            throw new ExecutionSetupException("Failed to create RecordReaders. " + e.getMessage(), (Throwable)e);
        }
        if (readers.size() == 0) {
            readers.add(new HiveRecordReader(table, null, null, columns, context, conf, ImpersonationUtil.createProxyUgi((String)config.getUserName(), (String)context.getQueryUserName())));
        }
        return new ScanBatch((PhysicalOperator)config, context, oContext, readers.iterator(), (List)partitionColumns, (List)selectedPartitionColumns);
    }

    private List<Integer> getRowGroupNumbersFromFileSplit(FileSplit split, ParquetMetadata footer) throws IOException {
        List blocks = footer.getBlocks();
        long splitStart = split.getStart();
        long splitLength = split.getLength();
        ArrayList rowGroupNums = Lists.newArrayList();
        int i = 0;
        for (BlockMetaData block : blocks) {
            long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
            if (firstDataPage >= splitStart && firstDataPage < splitStart + splitLength) {
                rowGroupNums.add(i);
            }
            ++i;
        }
        return rowGroupNums;
    }
}

