/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetSubScan;
import org.apache.drill.exec.store.hive.HiveMetadataProvider;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTable;

@JsonTypeName(value="hive-drill-native-parquet-scan")
public class HiveDrillNativeParquetScan
extends HiveScan {
    @JsonCreator
    public HiveDrillNativeParquetScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="hive-table") HiveReadEntry hiveReadEntry, @JsonProperty(value="storage-plugin") String storagePluginName, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        super(userName, hiveReadEntry, storagePluginName, columns, pluginRegistry);
    }

    public HiveDrillNativeParquetScan(String userName, HiveReadEntry hiveReadEntry, HiveStoragePlugin storagePlugin, List<SchemaPath> columns, HiveMetadataProvider metadataProvider) throws ExecutionSetupException {
        super(userName, hiveReadEntry, storagePlugin, columns, metadataProvider);
    }

    public HiveDrillNativeParquetScan(HiveScan hiveScan) {
        super(hiveScan);
    }

    @Override
    public ScanStats getScanStats() {
        ScanStats nativeHiveScanStats = super.getScanStats();
        return new ScanStats(nativeHiveScanStats.getGroupScanProperty(), nativeHiveScanStats.getRecordCount(), nativeHiveScanStats.getCpuCost() / (float)this.getSerDeOverheadFactor(), nativeHiveScanStats.getDiskCost());
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        try {
            return new HiveDrillNativeParquetSubScan((HiveSubScan)super.getSpecificScan(minorFragmentId));
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    @Override
    public boolean isNativeReader() {
        return true;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new HiveDrillNativeParquetScan(this);
    }

    @Override
    public HiveScan clone(HiveReadEntry hiveReadEntry) throws ExecutionSetupException {
        return new HiveDrillNativeParquetScan(this.getUserName(), hiveReadEntry, this.storagePlugin, (List<SchemaPath>)this.columns, this.metadataProvider);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        HiveDrillNativeParquetScan scan = new HiveDrillNativeParquetScan(this);
        scan.columns = columns;
        return scan;
    }

    @Override
    public String toString() {
        List<HiveTable.HivePartition> partitions = this.hiveReadEntry.getHivePartitionWrappers();
        int numPartitions = partitions == null ? 0 : partitions.size();
        return "HiveDrillNativeParquetScan [table=" + this.hiveReadEntry.getHiveTableWrapper() + ", columns=" + this.columns + ", numPartitions=" + numPartitions + ", partitions= " + partitions + ", inputDirectories=" + this.metadataProvider.getInputDirectories(this.hiveReadEntry) + "]";
    }
}

