/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthorizationHelper {
    private static final Logger logger = LoggerFactory.getLogger(HiveAuthorizationHelper.class);
    final boolean authzEnabled;
    final HiveAuthorizer authorizerV2;

    public HiveAuthorizationHelper(final IMetaStoreClient mClient, HiveConf hiveConf, String user) {
        this.authzEnabled = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED);
        if (!this.authzEnabled) {
            this.authorizerV2 = null;
            return;
        }
        try {
            HiveConf hiveConfCopy = new HiveConf(hiveConf);
            hiveConfCopy.set("user.name", user);
            HiveAuthenticationProvider authenticator = HiveUtils.getAuthenticator((Configuration)hiveConfCopy, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER);
            SessionState ss = new SessionState(hiveConfCopy, user);
            SessionState.start((SessionState)ss);
            authenticator.setSessionState(ss);
            HiveAuthorizerFactory authorizerFactory = HiveUtils.getAuthorizerFactory((Configuration)hiveConfCopy, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
            HiveAuthzSessionContext.Builder authzContextBuilder = new HiveAuthzSessionContext.Builder();
            authzContextBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2);
            this.authorizerV2 = authorizerFactory.createHiveAuthorizer(new HiveMetastoreClientFactory(){

                public IMetaStoreClient getHiveMetastoreClient() throws HiveAuthzPluginException {
                    return mClient;
                }
            }, hiveConf, authenticator, authzContextBuilder.build());
            this.authorizerV2.applyAuthorizationConfigPolicy(hiveConfCopy);
        }
        catch (HiveException e) {
            throw new DrillRuntimeException("Failed to initialize Hive authorization components: " + e.getMessage(), (Throwable)e);
        }
        logger.trace("Hive authorization enabled");
    }

    public void authorizeShowDatabases() throws HiveAccessControlException {
        if (!this.authzEnabled) {
            return;
        }
        this.authorize(HiveOperationType.SHOWDATABASES, Collections.emptyList(), Collections.emptyList(), "SHOW DATABASES");
    }

    public void authorizeShowTables(String dbName) throws HiveAccessControlException {
        if (!this.authzEnabled) {
            return;
        }
        HivePrivilegeObject toRead = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbName, null);
        this.authorize(HiveOperationType.SHOWTABLES, (List<HivePrivilegeObject>)ImmutableList.of((Object)toRead), Collections.emptyList(), "SHOW TABLES");
    }

    public void authorizeReadTable(String dbName, String tableName) throws HiveAccessControlException {
        if (!this.authzEnabled) {
            return;
        }
        HivePrivilegeObject toRead = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tableName);
        this.authorize(HiveOperationType.QUERY, (List<HivePrivilegeObject>)ImmutableList.of((Object)toRead), Collections.emptyList(), "READ TABLE");
    }

    private void authorize(HiveOperationType hiveOpType, List<HivePrivilegeObject> toRead, List<HivePrivilegeObject> toWrite, String cmd) throws HiveAccessControlException {
        try {
            HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
            authzContextBuilder.setUserIpAddress("Not available");
            authzContextBuilder.setCommandString(cmd);
            this.authorizerV2.checkPrivileges(hiveOpType, toRead, toWrite, authzContextBuilder.build());
        }
        catch (HiveAccessControlException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failed to use the Hive authorization components: " + e.getMessage(), (Throwable)e);
        }
    }
}

