/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.hive.HiveAuthorizationHelper;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillHiveMetaStoreClient
extends HiveMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DrillHiveMetaStoreClient.class);
    public final String HIVE_METASTORE_CACHE_TTL = "hive.metastore.cache-ttl-seconds";
    public final String HIVE_METASTORE_CACHE_EXPIRE = "hive.metastore.cache-expire-after";
    public final String HIVE_METASTORE_CACHE_EXPIRE_AFTER_WRITE = "write";
    public final String HIVE_METASTORE_CACHE_EXPIRE_AFTER_ACCESS = "access";
    protected final LoadingCache<String, List<String>> databases;
    protected final LoadingCache<String, List<String>> tableNameLoader;
    protected final LoadingCache<TableName, HiveReadEntry> tableLoaders;

    public static DrillHiveMetaStoreClient createClientWithAuthz(DrillHiveMetaStoreClient processUserMetaStoreClient, HiveConf hiveConf, final String userName) throws MetaException {
        try {
            HiveConf hiveConfForClient;
            UserGroupInformation ugiForRpc;
            boolean delegationTokenGenerated = false;
            if (!hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
                ugiForRpc = ImpersonationUtil.getProcessUserUGI();
            } else {
                ugiForRpc = ImpersonationUtil.createProxyUgi((String)userName);
                if (hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL)) {
                    String delegationToken = processUserMetaStoreClient.getDelegationToken(userName, userName);
                    try {
                        Utils.setTokenStr((UserGroupInformation)ugiForRpc, (String)delegationToken, (String)"DrillDelegationTokenForHiveMetaStoreServer");
                    }
                    catch (IOException e) {
                        throw new DrillRuntimeException("Couldn't setup delegation token in the UGI for Hive MetaStoreClient", (Throwable)e);
                    }
                    delegationTokenGenerated = true;
                }
            }
            if (delegationTokenGenerated) {
                hiveConfForClient = new HiveConf(hiveConf);
                hiveConfForClient.set("hive.metastore.token.signature", "DrillDelegationTokenForHiveMetaStoreServer");
            } else {
                hiveConfForClient = hiveConf;
            }
            return (DrillHiveMetaStoreClient)((Object)ugiForRpc.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DrillHiveMetaStoreClient>(){

                @Override
                public DrillHiveMetaStoreClient run() throws Exception {
                    return new HiveClientWithAuthzWithCaching(hiveConfForClient, ugiForRpc, userName);
                }
            }));
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failure setting up HiveMetaStore client.", (Throwable)e);
        }
    }

    public static DrillHiveMetaStoreClient createNonCloseableClientWithCaching(HiveConf hiveConf) throws MetaException {
        return new NonCloseableHiveClientWithCaching(hiveConf);
    }

    private DrillHiveMetaStoreClient(HiveConf hiveConf) throws MetaException {
        super(hiveConf);
        String expiry;
        int hmsCacheTTL = 60;
        boolean expireAfterWrite = true;
        String ttl = hiveConf.get("hive.metastore.cache-ttl-seconds");
        if (!Strings.isNullOrEmpty((String)ttl)) {
            hmsCacheTTL = Integer.valueOf(ttl);
            logger.warn("Hive metastore cache ttl is set to {} seconds.", (Object)hmsCacheTTL);
        }
        if (!Strings.isNullOrEmpty((String)(expiry = hiveConf.get("hive.metastore.cache-expire-after")))) {
            if (expiry.equalsIgnoreCase("write")) {
                expireAfterWrite = true;
            } else if (expiry.equalsIgnoreCase("access")) {
                expireAfterWrite = false;
            }
            logger.warn("Hive metastore cache expire policy is set to {}", (Object)(expireAfterWrite ? "expireAfterWrite" : "expireAfterAccess"));
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expireAfterWrite) {
            cacheBuilder.expireAfterWrite((long)hmsCacheTTL, TimeUnit.SECONDS);
        } else {
            cacheBuilder.expireAfterAccess((long)hmsCacheTTL, TimeUnit.SECONDS);
        }
        this.databases = cacheBuilder.build((CacheLoader)new DatabaseLoader());
        this.tableNameLoader = cacheBuilder.build((CacheLoader)new TableNameLoader());
        this.tableLoaders = cacheBuilder.build((CacheLoader)new TableLoader());
    }

    public abstract List<String> getDatabases(boolean var1) throws TException;

    public abstract List<String> getTableNames(String var1, boolean var2) throws TException;

    public abstract HiveReadEntry getHiveReadEntry(String var1, String var2, boolean var3) throws TException;

    protected static List<String> getDatabasesHelper(IMetaStoreClient mClient) throws TException {
        try {
            return mClient.getAllDatabases();
        }
        catch (TException e) {
            logger.warn("Failure while attempting to get hive databases", (Throwable)e);
            mClient.reconnect();
            return mClient.getAllDatabases();
        }
    }

    protected static List<String> getTableNamesHelper(IMetaStoreClient mClient, String dbName) throws TException {
        try {
            return mClient.getAllTables(dbName);
        }
        catch (TException e) {
            logger.warn("Failure while attempting to get hive tables", (Throwable)e);
            mClient.reconnect();
            return mClient.getAllTables(dbName);
        }
    }

    protected static HiveReadEntry getHiveReadEntryHelper(IMetaStoreClient mClient, String dbName, String tableName) throws TException {
        List partitions;
        Table t = null;
        try {
            t = mClient.getTable(dbName, tableName);
        }
        catch (TException e) {
            mClient.reconnect();
            t = mClient.getTable(dbName, tableName);
        }
        if (t == null) {
            throw new UnknownTableException(String.format("Unable to find table '%s'.", tableName));
        }
        try {
            partitions = mClient.listPartitions(dbName, tableName, (short)-1);
        }
        catch (TException e) {
            mClient.reconnect();
            partitions = mClient.listPartitions(dbName, tableName, (short)-1);
        }
        ArrayList hivePartitions = Lists.newArrayList();
        for (Partition part : partitions) {
            hivePartitions.add(new HiveTable.HivePartition(part));
        }
        if (hivePartitions.size() == 0) {
            hivePartitions = null;
        }
        return new HiveReadEntry(new HiveTable(t), hivePartitions);
    }

    static class TableName {
        private final String databaseName;
        private final String tableName;

        private TableName(String databaseName, String tableName) {
            this.databaseName = databaseName;
            this.tableName = tableName;
        }

        public static TableName table(String databaseName, String tableName) {
            return new TableName(databaseName, tableName);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return String.format("databaseName:%s, tableName:%s", this.databaseName, this.tableName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableName other = (TableName)o;
            return Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.tableName, other.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.databaseName, this.tableName);
        }
    }

    private class TableLoader
    extends CacheLoader<TableName, HiveReadEntry> {
        private TableLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HiveReadEntry load(TableName key) throws Exception {
            DrillHiveMetaStoreClient drillHiveMetaStoreClient = DrillHiveMetaStoreClient.this;
            synchronized (drillHiveMetaStoreClient) {
                return DrillHiveMetaStoreClient.getHiveReadEntryHelper((IMetaStoreClient)DrillHiveMetaStoreClient.this, key.getDatabaseName(), key.getTableName());
            }
        }
    }

    private class TableNameLoader
    extends CacheLoader<String, List<String>> {
        private TableNameLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> load(String dbName) throws Exception {
            DrillHiveMetaStoreClient drillHiveMetaStoreClient = DrillHiveMetaStoreClient.this;
            synchronized (drillHiveMetaStoreClient) {
                return DrillHiveMetaStoreClient.getTableNamesHelper((IMetaStoreClient)DrillHiveMetaStoreClient.this, dbName);
            }
        }
    }

    private class DatabaseLoader
    extends CacheLoader<String, List<String>> {
        private DatabaseLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> load(String key) throws Exception {
            if (!"databases".equals(key)) {
                throw new UnsupportedOperationException();
            }
            DrillHiveMetaStoreClient drillHiveMetaStoreClient = DrillHiveMetaStoreClient.this;
            synchronized (drillHiveMetaStoreClient) {
                return DrillHiveMetaStoreClient.getDatabasesHelper((IMetaStoreClient)DrillHiveMetaStoreClient.this);
            }
        }
    }

    private static class NonCloseableHiveClientWithCaching
    extends DrillHiveMetaStoreClient {
        private NonCloseableHiveClientWithCaching(HiveConf hiveConf) throws MetaException {
            super(hiveConf);
        }

        @Override
        public List<String> getDatabases(boolean ignoreAuthzErrors) throws TException {
            try {
                return (List)this.databases.get((Object)"databases");
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        @Override
        public List<String> getTableNames(String dbName, boolean ignoreAuthzErrors) throws TException {
            try {
                return (List)this.tableNameLoader.get((Object)dbName);
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        @Override
        public HiveReadEntry getHiveReadEntry(String dbName, String tableName, boolean ignoreAuthzErrors) throws TException {
            try {
                return (HiveReadEntry)this.tableLoaders.get((Object)TableName.table(dbName, tableName));
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws TException {
            NonCloseableHiveClientWithCaching nonCloseableHiveClientWithCaching = this;
            synchronized (nonCloseableHiveClientWithCaching) {
                return super.getDelegationToken(owner, renewerKerberosPrincipalName);
            }
        }

        public void close() {
        }
    }

    private static class HiveClientWithAuthzWithCaching
    extends DrillHiveMetaStoreClient {
        public static final String DRILL2HMS_TOKEN = "DrillDelegationTokenForHiveMetaStoreServer";
        private final UserGroupInformation ugiForRpc;
        private HiveAuthorizationHelper authorizer;

        private HiveClientWithAuthzWithCaching(HiveConf hiveConf, UserGroupInformation ugiForRpc, String userName) throws TException {
            super(hiveConf);
            this.ugiForRpc = ugiForRpc;
            this.authorizer = new HiveAuthorizationHelper((IMetaStoreClient)this, hiveConf, userName);
        }

        public void reconnect() throws MetaException {
            try {
                this.ugiForRpc.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        HiveClientWithAuthzWithCaching.this.reconnectSuper();
                        return null;
                    }
                });
            }
            catch (IOException | InterruptedException e) {
                throw new DrillRuntimeException("Failed to reconnect to HiveMetaStore: " + e.getMessage(), (Throwable)e);
            }
        }

        private void reconnectSuper() throws MetaException {
            super.reconnect();
        }

        @Override
        public List<String> getDatabases(boolean ignoreAuthzErrors) throws TException {
            try {
                this.authorizer.authorizeShowDatabases();
            }
            catch (HiveAccessControlException e) {
                if (ignoreAuthzErrors) {
                    return Collections.emptyList();
                }
                throw UserException.permissionError((Throwable)e).build(logger);
            }
            try {
                return (List)this.databases.get((Object)"databases");
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        @Override
        public List<String> getTableNames(String dbName, boolean ignoreAuthzErrors) throws TException {
            try {
                this.authorizer.authorizeShowTables(dbName);
            }
            catch (HiveAccessControlException e) {
                if (ignoreAuthzErrors) {
                    return Collections.emptyList();
                }
                throw UserException.permissionError((Throwable)e).build(logger);
            }
            try {
                return (List)this.tableNameLoader.get((Object)dbName);
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }

        @Override
        public HiveReadEntry getHiveReadEntry(String dbName, String tableName, boolean ignoreAuthzErrors) throws TException {
            block4: {
                try {
                    this.authorizer.authorizeReadTable(dbName, tableName);
                }
                catch (HiveAccessControlException e) {
                    if (ignoreAuthzErrors) break block4;
                    throw UserException.permissionError((Throwable)e).build(logger);
                }
            }
            try {
                return (HiveReadEntry)this.tableLoaders.get((Object)TableName.table(dbName, tableName));
            }
            catch (ExecutionException e) {
                throw new TException((Throwable)e);
            }
        }
    }
}

