/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.logical;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.sql.DrillSqlOperator;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.hive.HiveDrillNativeParquetScan;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHiveParquetScanToDrillParquetScan
extends StoragePluginOptimizerRule {
    private static final Logger logger = LoggerFactory.getLogger(ConvertHiveParquetScanToDrillParquetScan.class);
    public static final ConvertHiveParquetScanToDrillParquetScan INSTANCE = new ConvertHiveParquetScanToDrillParquetScan();
    private static final DrillSqlOperator INT96_TO_TIMESTAMP = new DrillSqlOperator("convert_fromTIMESTAMP_IMPALA", 1, true);

    private ConvertHiveParquetScanToDrillParquetScan() {
        super(RelOptHelper.any(DrillScanRel.class), "ConvertHiveScanToHiveDrillNativeScan:Parquet");
    }

    public boolean matches(RelOptRuleCall call) {
        DrillScanRel scanRel = (DrillScanRel)call.rel(0);
        if (!(scanRel.getGroupScan() instanceof HiveScan) || ((HiveScan)scanRel.getGroupScan()).isNativeReader()) {
            return false;
        }
        HiveScan hiveScan = (HiveScan)scanRel.getGroupScan();
        HiveConf hiveConf = hiveScan.getHiveConf();
        Table hiveTable = hiveScan.hiveReadEntry.getTable();
        Class<InputFormat<?, ?>> tableInputFormat = this.getInputFormatFromSD(MetaStoreUtils.getTableMetadata((Table)hiveTable), hiveScan.hiveReadEntry, hiveTable.getSd(), hiveConf);
        if (tableInputFormat == null || !tableInputFormat.equals(MapredParquetInputFormat.class)) {
            return false;
        }
        List<HiveTable.HivePartition> partitions = hiveScan.hiveReadEntry.getHivePartitionWrappers();
        if (partitions == null) {
            return true;
        }
        List tableSchema = hiveTable.getSd().getCols();
        for (HiveTable.HivePartition partition : partitions) {
            StorageDescriptor partitionSD = partition.getPartition().getSd();
            Class<InputFormat<?, ?>> inputFormat = this.getInputFormatFromSD(HiveUtilities.getPartitionMetadata(partition.getPartition(), hiveTable), hiveScan.hiveReadEntry, partitionSD, hiveConf);
            if (inputFormat == null || !inputFormat.equals(tableInputFormat)) {
                return false;
            }
            if (partitionSD.getCols().equals(tableSchema)) continue;
            logger.debug("Partitions schema is different from table schema. Currently native reader conversion can't handle schema difference between partitions and table");
            return false;
        }
        return true;
    }

    private Class<? extends InputFormat<?, ?>> getInputFormatFromSD(Properties properties, HiveReadEntry hiveReadEntry, StorageDescriptor sd, HiveConf hiveConf) {
        Table hiveTable = hiveReadEntry.getTable();
        try {
            String inputFormatName = sd.getInputFormat();
            if (!Strings.isNullOrEmpty((String)inputFormatName)) {
                return Class.forName(inputFormatName);
            }
            JobConf job = new JobConf((Configuration)hiveConf);
            HiveUtilities.addConfToJob(job, properties);
            return HiveUtilities.getInputFormatClass(job, sd, hiveTable);
        }
        catch (Exception e) {
            logger.warn("Failed to get InputFormat class from Hive table '{}.{}'. StorageDescriptor [{}]", new Object[]{hiveTable.getDbName(), hiveTable.getTableName(), sd.toString(), e});
            return null;
        }
    }

    public void onMatch(RelOptRuleCall call) {
        try {
            DrillScanRel hiveScanRel = (DrillScanRel)call.rel(0);
            HiveScan hiveScan = (HiveScan)hiveScanRel.getGroupScan();
            PlannerSettings settings = PrelUtil.getPlannerSettings((RelOptPlanner)call.getPlanner());
            String partitionColumnLabel = settings.getFsPartitionColumnLabel();
            Table hiveTable = hiveScan.hiveReadEntry.getTable();
            this.checkForUnsupportedDataTypes(hiveTable);
            Map<String, String> partitionColMapping = this.getPartitionColMapping(hiveTable, partitionColumnLabel);
            DrillScanRel nativeScanRel = this.createNativeScanRel(partitionColMapping, hiveScanRel);
            if (hiveScanRel.getRowType().getFieldCount() == 0) {
                call.transformTo((RelNode)nativeScanRel);
            } else {
                DrillProjectRel projectRel = this.createProjectRel(hiveScanRel, partitionColMapping, nativeScanRel);
                call.transformTo((RelNode)projectRel);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to convert HiveScan to HiveDrillNativeParquetScan", (Throwable)e);
        }
    }

    private Map<String, String> getPartitionColMapping(Table hiveTable, String partitionColumnLabel) {
        HashMap partitionColMapping = Maps.newHashMap();
        int i = 0;
        for (FieldSchema col : hiveTable.getPartitionKeys()) {
            partitionColMapping.put(col.getName(), partitionColumnLabel + i);
            ++i;
        }
        return partitionColMapping;
    }

    private DrillScanRel createNativeScanRel(Map<String, String> partitionColMapping, DrillScanRel hiveScanRel) throws Exception {
        RelDataTypeFactory typeFactory = hiveScanRel.getCluster().getTypeFactory();
        RelDataType varCharType = typeFactory.createSqlType(SqlTypeName.VARCHAR);
        ArrayList nativeScanColNames = Lists.newArrayList();
        ArrayList nativeScanColTypes = Lists.newArrayList();
        for (RelDataTypeField field : hiveScanRel.getRowType().getFieldList()) {
            String dirColName = partitionColMapping.get(field.getName());
            if (dirColName != null) {
                nativeScanColNames.add(dirColName);
                nativeScanColTypes.add(varCharType);
                continue;
            }
            nativeScanColNames.add(field.getName());
            nativeScanColTypes.add(field.getType());
        }
        RelDataType nativeScanRowType = typeFactory.createStructType((List)nativeScanColTypes, (List)nativeScanColNames);
        ArrayList nativeScanCols = Lists.newArrayList();
        for (SchemaPath colName : hiveScanRel.getColumns()) {
            String partitionCol = partitionColMapping.get(colName.getAsUnescapedPath());
            if (partitionCol != null) {
                nativeScanCols.add(SchemaPath.getSimplePath((String)partitionCol));
                continue;
            }
            nativeScanCols.add(colName);
        }
        HiveScan hiveScan = (HiveScan)hiveScanRel.getGroupScan();
        HiveDrillNativeParquetScan nativeHiveScan = new HiveDrillNativeParquetScan(hiveScan.getUserName(), hiveScan.hiveReadEntry, hiveScan.storagePlugin, (List<SchemaPath>)nativeScanCols, null);
        return new DrillScanRel(hiveScanRel.getCluster(), hiveScanRel.getTraitSet(), hiveScanRel.getTable(), (GroupScan)nativeHiveScan, nativeScanRowType, (List)nativeScanCols);
    }

    private DrillProjectRel createProjectRel(DrillScanRel hiveScanRel, Map<String, String> partitionColMapping, DrillScanRel nativeScanRel) {
        ArrayList rexNodes = Lists.newArrayList();
        RexBuilder rb = hiveScanRel.getCluster().getRexBuilder();
        RelDataType hiveScanRowType = hiveScanRel.getRowType();
        for (String colName : hiveScanRowType.getFieldNames()) {
            String dirColName = partitionColMapping.get(colName);
            if (dirColName != null) {
                rexNodes.add(this.createPartitionColumnCast(hiveScanRel, nativeScanRel, colName, dirColName, rb));
                continue;
            }
            rexNodes.add(this.createColumnFormatConversion(hiveScanRel, nativeScanRel, colName, rb));
        }
        return DrillProjectRel.create((RelOptCluster)hiveScanRel.getCluster(), (RelTraitSet)hiveScanRel.getTraitSet(), (RelNode)nativeScanRel, (List)rexNodes, (RelDataType)hiveScanRowType);
    }

    private RexNode createColumnFormatConversion(DrillScanRel hiveScanRel, DrillScanRel nativeScanRel, String colName, RexBuilder rb) {
        RelDataType outputType = hiveScanRel.getRowType().getField(colName, false, false).getType();
        RelDataTypeField inputField = nativeScanRel.getRowType().getField(colName, false, false);
        RexInputRef inputRef = rb.makeInputRef(inputField.getType(), inputField.getIndex());
        if (outputType.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
            return rb.makeCall((SqlOperator)INT96_TO_TIMESTAMP, new RexNode[]{inputRef});
        }
        return inputRef;
    }

    private RexNode createPartitionColumnCast(DrillScanRel hiveScanRel, DrillScanRel nativeScanRel, String outputColName, String dirColName, RexBuilder rb) {
        RelDataType outputType = hiveScanRel.getRowType().getField(outputColName, false, false).getType();
        RelDataTypeField inputField = nativeScanRel.getRowType().getField(dirColName, false, false);
        RexInputRef inputRef = rb.makeInputRef(rb.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), inputField.getIndex());
        return rb.makeCast(outputType, (RexNode)inputRef);
    }

    private void checkForUnsupportedDataTypes(Table hiveTable) {
        for (FieldSchema hiveField : hiveTable.getSd().getCols()) {
            ObjectInspector.Category category = TypeInfoUtils.getTypeInfoFromTypeString((String)hiveField.getType()).getCategory();
            if (category != ObjectInspector.Category.MAP && category != ObjectInspector.Category.STRUCT && category != ObjectInspector.Category.UNION && category != ObjectInspector.Category.LIST) continue;
            HiveUtilities.throwUnsupportedHiveDataTypeError(category.toString());
        }
    }
}

