/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;

public class DrillVar16CharObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements StringObjectInspector {
        public Optional() {
            super(TypeInfoFactory.stringTypeInfo);
        }

        public Text getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVar16CharHolder h = (NullableVar16CharHolder)o;
            return new Text(StringFunctionHelpers.toStringFromUTF16((int)h.start, (int)h.end, (DrillBuf)h.buffer));
        }

        public String getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVar16CharHolder h = (NullableVar16CharHolder)o;
            return StringFunctionHelpers.toStringFromUTF16((int)h.start, (int)h.end, (DrillBuf)h.buffer);
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements StringObjectInspector {
        public Required() {
            super(TypeInfoFactory.stringTypeInfo);
        }

        public Text getPrimitiveWritableObject(Object o) {
            Var16CharHolder h = (Var16CharHolder)o;
            return new Text(StringFunctionHelpers.toStringFromUTF16((int)h.start, (int)h.end, (DrillBuf)h.buffer));
        }

        public String getPrimitiveJavaObject(Object o) {
            Var16CharHolder h = (Var16CharHolder)o;
            return StringFunctionHelpers.toStringFromUTF16((int)h.start, (int)h.end, (DrillBuf)h.buffer);
        }
    }
}

