/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.fn.HiveFuncHolder;
import org.apache.drill.exec.expr.fn.PluggableFunctionRegistry;
import org.apache.drill.exec.expr.fn.impl.hive.ObjectInspectorHelper;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.sql.HiveUDFOperator;
import org.apache.drill.exec.planner.sql.HiveUDFOperatorWithoutInference;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveFunctionRegistry
implements PluggableFunctionRegistry {
    static final Logger logger = LoggerFactory.getLogger(HiveFunctionRegistry.class);
    private ArrayListMultimap<String, Class<? extends GenericUDF>> methodsGenericUDF = ArrayListMultimap.create();
    private ArrayListMultimap<String, Class<? extends UDF>> methodsUDF = ArrayListMultimap.create();
    private HashSet<Class<?>> nonDeterministicUDFs = new HashSet();

    public HiveFunctionRegistry(DrillConfig config) {
        ScanResult classpathScan = ClassPathScanner.fromPrescan((DrillConfig)config);
        Set genericUDFClasses = classpathScan.getImplementations(GenericUDF.class);
        for (Class clazz : genericUDFClasses) {
            this.register(clazz, this.methodsGenericUDF);
        }
        Set udfClasses = classpathScan.getImplementations(UDF.class);
        for (Class clazz : udfClasses) {
            this.register(clazz, this.methodsUDF);
        }
    }

    public void register(DrillOperatorTable operatorTable) {
        for (String name : Sets.union(this.methodsGenericUDF.asMap().keySet(), this.methodsUDF.asMap().keySet())) {
            operatorTable.addOperatorWithoutInference(name, (SqlOperator)new HiveUDFOperatorWithoutInference(name.toUpperCase()));
            operatorTable.addOperatorWithInference(name, (SqlOperator)new HiveUDFOperator(name.toUpperCase(), new HiveSqlReturnTypeInference(operatorTable.getOptionManager())));
        }
    }

    private <C, I> void register(Class<? extends I> clazz, ArrayListMultimap<String, Class<? extends I>> methods) {
        UDFType type;
        String[] names;
        Description desc = clazz.getAnnotation(Description.class);
        if (desc != null) {
            names = desc.name().split(",");
            for (int i = 0; i < names.length; ++i) {
                names[i] = names[i].trim();
            }
        } else {
            names = new String[]{clazz.getName().replace('.', '_')};
        }
        if ((type = clazz.getAnnotation(UDFType.class)) != null && type.deterministic()) {
            this.nonDeterministicUDFs.add(clazz);
        }
        for (int i = 0; i < names.length; ++i) {
            methods.put((Object)names[i].toLowerCase(), clazz);
        }
    }

    public HiveFuncHolder getFunction(FunctionCall call) {
        HiveFuncHolder h = this.resolveFunction(call, false);
        if (h != null) {
            return h;
        }
        return this.resolveFunction(call, true);
    }

    private HiveFuncHolder resolveFunction(FunctionCall call, boolean convertVarCharToVar16Char) {
        HiveFuncHolder holder;
        TypeProtos.MajorType[] argTypes = new TypeProtos.MajorType[call.args.size()];
        ObjectInspector[] argOIs = new ObjectInspector[call.args.size()];
        for (int i = 0; i < call.args.size(); ++i) {
            try {
                argTypes[i] = ((LogicalExpression)call.args.get(i)).getMajorType();
                if (convertVarCharToVar16Char && argTypes[i].getMinorType() == TypeProtos.MinorType.VARCHAR) {
                    argTypes[i] = Types.withMode((TypeProtos.MinorType)TypeProtos.MinorType.VAR16CHAR, (TypeProtos.DataMode)argTypes[i].getMode());
                }
                argOIs[i] = ObjectInspectorHelper.getDrillObjectInspector(argTypes[i].getMode(), argTypes[i].getMinorType());
                continue;
            }
            catch (Exception e) {
                logger.trace("Failed to find a hive function for given FunctionCall: '{}'", (Object)call.toString(), (Object)e);
                return null;
            }
        }
        String funcName = call.getName().toLowerCase();
        for (Class clazz : this.methodsGenericUDF.get((Object)funcName)) {
            holder = this.matchAndCreateGenericUDFHolder(clazz, argTypes, argOIs);
            if (holder == null) continue;
            return holder;
        }
        for (Class clazz : this.methodsUDF.get((Object)funcName)) {
            holder = this.matchAndCreateUDFHolder(call.getName(), clazz, argTypes, argOIs);
            if (holder == null) continue;
            return holder;
        }
        return null;
    }

    private HiveFuncHolder matchAndCreateGenericUDFHolder(Class<? extends GenericUDF> udfClazz, TypeProtos.MajorType[] argTypes, ObjectInspector[] argOIs) {
        try {
            GenericUDF udfInstance = udfClazz.newInstance();
            ObjectInspector returnOI = udfInstance.initialize(argOIs);
            return new HiveFuncHolder(udfClazz, argTypes, returnOI, Types.optional((TypeProtos.MinorType)ObjectInspectorHelper.getDrillType(returnOI)), this.nonDeterministicUDFs.contains(udfClazz));
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.debug("Failed to instantiate class", (Throwable)e);
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private HiveFuncHolder matchAndCreateUDFHolder(String udfName, Class<? extends UDF> udfClazz, TypeProtos.MajorType[] argTypes, ObjectInspector[] argOIs) {
        try {
            GenericUDFBridge udfInstance = new GenericUDFBridge(udfName, false, udfClazz.getName());
            ObjectInspector returnOI = udfInstance.initialize(argOIs);
            return new HiveFuncHolder(udfName, udfClazz, argTypes, returnOI, Types.optional((TypeProtos.MinorType)ObjectInspectorHelper.getDrillType(returnOI)), this.nonDeterministicUDFs.contains(udfClazz));
        }
        catch (Exception e) {
            return null;
        }
    }

    public class HiveSqlReturnTypeInference
    implements SqlReturnTypeInference {
        private OptionManager optionManager;

        private HiveSqlReturnTypeInference(OptionManager optionManager) {
            this.optionManager = optionManager;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (!this.optionManager.getOption((String)"planner.enable_decimal_data_type").bool_val.booleanValue()) {
                opBinding = TypeInferenceUtils.convertDecimalLiteralToDouble((SqlOperatorBinding)opBinding);
            }
            for (RelDataType type : opBinding.collectOperandTypes()) {
                TypeProtos.MinorType minorType = TypeInferenceUtils.getDrillTypeFromCalciteType((RelDataType)type);
                if (minorType != TypeProtos.MinorType.LATE) continue;
                return opBinding.getTypeFactory().createTypeWithNullability(opBinding.getTypeFactory().createSqlType(SqlTypeName.ANY), true);
            }
            FunctionCall functionCall = TypeInferenceUtils.convertSqlOperatorBindingToFunctionCall((SqlOperatorBinding)opBinding);
            HiveFuncHolder hiveFuncHolder = HiveFunctionRegistry.this.getFunction(functionCall);
            if (hiveFuncHolder == null) {
                StringBuilder operandTypes = new StringBuilder();
                for (int j = 0; j < opBinding.getOperandCount(); ++j) {
                    operandTypes.append(opBinding.getOperandType(j).getSqlTypeName());
                    if (j >= opBinding.getOperandCount() - 1) continue;
                    operandTypes.append(",");
                }
                throw UserException.functionError().message(String.format("%s does not support operand types (%s)", opBinding.getOperator().getName(), operandTypes), new Object[0]).build(logger);
            }
            return TypeInferenceUtils.createCalciteTypeWithNullability((RelDataTypeFactory)opBinding.getTypeFactory(), (SqlTypeName)TypeInferenceUtils.getCalciteTypeFromDrillType((TypeProtos.MinorType)hiveFuncHolder.getReturnType().getMinorType()), (hiveFuncHolder.getReturnType().getMode() != TypeProtos.DataMode.REQUIRED ? 1 : 0) != 0);
        }
    }
}

