/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.impl.Constants;
import com.mapr.db.rowcol.BaseSerializationContext;
import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;

public class SerializationContext
extends BaseSerializationContext {
    byte flags;
    DBDocumentImpl rec;
    Map<FieldPath, Integer> jsonPathMap;
    private KeyValue currentKV;
    private FamilyInfo[] familyInfoList;
    private int lastSearchIndex = -1;
    private boolean fullRecordOp = false;
    private boolean hasMutation = false;
    private boolean storeRowTS = false;
    private boolean decodeTimestamp = false;
    private boolean preserveDeleteTime = false;
    private TimeAndUniq baseTime;
    private boolean hasDeletes = false;

    public void setHasDeletes(boolean v) {
        this.hasDeletes = v;
    }

    public boolean hasDeletes() {
        return this.hasDeletes;
    }

    public void setPreserveDeleteTime(boolean v) {
        this.preserveDeleteTime = v;
    }

    public boolean preserveDeleteTime() {
        return this.preserveDeleteTime;
    }

    public void setDecodeTimestamp(boolean v) {
        this.decodeTimestamp = v;
    }

    public boolean getDecodeTimestamp() {
        return this.decodeTimestamp;
    }

    void setupFamilyList(DBDocumentImpl r, Map<FieldPath, Integer> jsonPathMap) {
        assert (jsonPathMap.size() > 0);
        this.jsonPathMap = jsonPathMap;
        this.rec = r;
        this.familyInfoList = new FamilyInfo[jsonPathMap.size()];
        int i = 0;
        for (Map.Entry<FieldPath, Integer> kv : jsonPathMap.entrySet()) {
            this.familyInfoList[i++] = this.setupFamilyInfo(kv.getKey(), kv.getValue());
        }
    }

    private FamilyInfo setupFamilyInfo(FieldPath path, int id) {
        FamilyInfo info = new FamilyInfo();
        KeyValue kv = null;
        KeyValue lastParentKV = this.rec;
        InsertContext.OpType opType = InsertContext.OpType.NONE;
        if (path.equals((Object)FieldPath.EMPTY)) {
            kv = this.rec;
        } else {
            String key;
            KeyValue tmpkv;
            FieldSegment field;
            Iterator iter = path.iterator();
            DBDocumentImpl curRec = this.rec;
            while ((field = (FieldSegment)iter.next()) != null && (tmpkv = curRec.map.get(key = field.getNameSegment().getName())) != null) {
                if (tmpkv.opType != InsertContext.OpType.NONE) {
                    assert (opType == InsertContext.OpType.NONE);
                    opType = tmpkv.opType;
                }
                if (field.isLastPath()) {
                    kv = tmpkv;
                    break;
                }
                lastParentKV = tmpkv;
                if (tmpkv.getType() != Value.Type.MAP) {
                    kv = null;
                    break;
                }
                curRec = (DBDocumentImpl)tmpkv;
            }
        }
        info.rootKV = kv;
        info.parentKV = lastParentKV;
        info.familyId = id;
        info.jsonPath = path;
        info.opType = opType;
        if (kv != null) {
            info.writer = new ByteWriter();
            kv.setRootOfColumnFamily(true);
            kv.setCFRootId(id);
        }
        return info;
    }

    public SerializedFamilyInfo[] getSerializedBuffers(Map<FieldPath, Integer> jsonPathMap, Map<Integer, ByteBuffer> cachedBufferMap) {
        assert (jsonPathMap.size() > 0);
        assert (cachedBufferMap.size() > 0);
        TreeMap<Integer, FamilyInfo> famInfoMap = new TreeMap<Integer, FamilyInfo>();
        for (Map.Entry<FieldPath, Integer> kv : jsonPathMap.entrySet()) {
            famInfoMap.put(kv.getValue(), new FamilyInfo(kv.getValue(), kv.getKey(), cachedBufferMap.get(kv.getValue())));
        }
        SerializedFamilyInfo[] famInfos = new FamilyInfo[famInfoMap.size()];
        int i = 0;
        for (Map.Entry fi : famInfoMap.entrySet()) {
            famInfos[i++] = (FamilyInfo)fi.getValue();
        }
        return famInfos;
    }

    public void serializeFamilies(DBDocumentImpl r, Map<FieldPath, Integer> jsonPathMap) {
        this.setupFamilyList(r, jsonPathMap);
        if (this.isFullRecordOp()) {
            TimeDescriptor.setCreateTimeValid(r);
            TimeDescriptor.setUpdateTimeValid(r);
            TimeDescriptor.setDeleteTimeValid(r);
        }
        for (int i = 0; i < this.familyInfoList.length; ++i) {
            FamilyInfo info = this.familyInfoList[i];
            if (info.rootKV == null) {
                if (this.isFullRecordOp()) {
                    info.action = SerializationAction.DELETE_FAMILY;
                    continue;
                }
                if (info.parentKV.getType() != Value.Type.MAP) {
                    info.action = SerializationAction.DELETE_FAMILY;
                    continue;
                }
                if (info.opType == InsertContext.OpType.NONE) {
                    info.action = SerializationAction.NO_ACTION;
                    continue;
                }
                if (info.opType != InsertContext.OpType.MERGE) {
                    info.action = SerializationAction.DELETE_FAMILY;
                    continue;
                }
                info.action = SerializationAction.NO_ACTION;
                continue;
            }
            info.action = SerializationAction.SET;
            if (info.jsonPath.equals((Object)FieldPath.EMPTY)) {
                this.rec.serializeToRowCol(info.writer, this);
            } else {
                DBDocumentImpl dummyRoot = new DBDocumentImpl();
                if (this.isFullRecordOp()) {
                    TimeDescriptor.setCreateTimeValid(dummyRoot);
                    TimeDescriptor.setUpdateTimeValid(dummyRoot);
                    TimeDescriptor.setDeleteTimeValid(dummyRoot);
                } else {
                    switch (info.opType) {
                        case NONE: {
                            if (TimeDescriptor.isCreateTimeValid(info.rootKV)) {
                                TimeDescriptor.setCreateTimeValid(dummyRoot);
                            }
                            if (TimeDescriptor.isUpdateTimeValid(info.rootKV)) {
                                TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            }
                            if (!TimeDescriptor.isDeleteTimeValid(info.rootKV)) break;
                            TimeDescriptor.setDeleteTimeValid(dummyRoot);
                            break;
                        }
                        case DELETE: {
                            assert (TimeDescriptor.isDeleteTimeValid(info.rootKV));
                            assert (!TimeDescriptor.isCreateTimeValid(info.rootKV));
                            assert (TimeDescriptor.isUpdateTimeValid(info.rootKV));
                            TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            TimeDescriptor.setDeleteTimeValid(dummyRoot);
                            break;
                        }
                        case MERGE: 
                        case APPEND: 
                        case INCREMENT: {
                            assert (!TimeDescriptor.isDeleteTimeValid(info.rootKV));
                            assert (TimeDescriptor.isCreateTimeValid(info.rootKV));
                            assert (TimeDescriptor.isUpdateTimeValid(info.rootKV));
                            TimeDescriptor.setCreateTimeValid(dummyRoot);
                            TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            break;
                        }
                        case SET: 
                        case SET_OR_REPLACE: {
                            assert (TimeDescriptor.isCreateTimeValid(info.rootKV));
                            assert (TimeDescriptor.isUpdateTimeValid(info.rootKV));
                            TimeDescriptor.setCreateTimeValid(dummyRoot);
                            TimeDescriptor.setUpdateTimeValid(dummyRoot);
                            TimeDescriptor.setDeleteTimeValid(dummyRoot);
                        }
                    }
                }
                this.currentKV = info.rootKV.shallowCopy();
                this.currentKV.key = "v";
                this.currentKV.timeDescriptor = info.rootKV.timeDescriptor;
                this.currentKV.opType = info.rootKV.opType;
                this.currentKV.setRootOfColumnFamily(false);
                dummyRoot.map.put("v", this.currentKV);
                this.hasMutation = false;
                dummyRoot.serializeToRowCol(info.writer, this);
            }
            if (this.isFullRecordOp() || this.hasMutation || info.opType != InsertContext.OpType.NONE) continue;
            info.action = SerializationAction.NO_ACTION;
            info.writer = null;
        }
    }

    public SerializedFamilyInfo[] getSerializedBuffers() {
        return this.familyInfoList;
    }

    boolean isFamilyRoot(KeyValue kv) {
        if (this.familyInfoList == null || this.currentKV == kv) {
            return false;
        }
        for (int i = 1; i <= this.familyInfoList.length; ++i) {
            int index = (i + this.lastSearchIndex) % this.familyInfoList.length;
            if (this.familyInfoList[index].rootKV != kv) continue;
            this.lastSearchIndex = i;
            return true;
        }
        return false;
    }

    public void setHasArrayProjection() {
        this.flags = 1;
    }

    public boolean hasArrayProjection() {
        return this.flags != 0;
    }

    public void setFullRecordOp(boolean v) {
        this.fullRecordOp = v;
    }

    public boolean isFullRecordOp() {
        return this.fullRecordOp;
    }

    public void setHasMutation(boolean v) {
        this.hasMutation = v;
    }

    public boolean hasMutation() {
        return this.hasMutation;
    }

    private boolean pathIsOwner(String pathSoFar, FieldPath cfPath, Map<FieldPath, Integer> jsonPathMap) {
        FieldPath curPath = FieldPath.parseFrom((String)pathSoFar);
        Integer idx = jsonPathMap.get(curPath);
        return idx == null || cfPath.equals((Object)curPath);
    }

    DBDocumentImpl decode(Map<Integer, ByteBuffer> map, Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, boolean restoreOrder, DBDocumentImpl rec) {
        Iterator<Map.Entry<FieldPath, Integer>> iter = jsonPathMap.entrySet().iterator();
        for (int i = 0; i < jsonPathMap.size(); ++i) {
            Map.Entry<FieldPath, Integer> e = iter.next();
            FieldPath path = e.getKey();
            int cfId = e.getValue();
            ByteBuffer buf = map.get(cfId);
            if (i == 0) {
                if (buf == null) continue;
                rec.deserializeFromRowCol(buf, this);
                continue;
            }
            if (buf == null) continue;
            DBDocumentImpl r = new DBDocumentImpl();
            r.deserializeFromRowCol(buf, this);
            KeyValue kv = r.getKeyValue(Constants.DUMMY_FIELDPATH_V);
            kv.setRecursiveNonDefaultColumnFamily(true, cfId);
            rec.set(path, (Value)kv);
            Iterator fpiter = path.iterator();
            String pathSoFar = null;
            while (fpiter.hasNext()) {
                FieldSegment field = (FieldSegment)fpiter.next();
                String thisKey = field.getNameSegment().getName();
                boolean ret = this.pathIsOwner(pathSoFar = pathSoFar == null ? thisKey : pathSoFar + "." + thisKey, path, jsonPathMap);
                if (!ret) continue;
                KeyValue rkv = rec.getKeyValue(pathSoFar);
                rkv.setPartOfNonDefaultColumnFamily(true);
                rkv.setCFRootId(cfId);
            }
        }
        if (restoreOrder) {
            return rec.restoreOrder(idToCFNameMap);
        }
        return rec;
    }

    public void setStoreRowTS(boolean v) {
        this.storeRowTS = v;
    }

    public boolean storeRowTS() {
        return this.storeRowTS;
    }

    public void setBaseTime(long time, int uniq) {
        this.baseTime = new TimeAndUniq(time, uniq);
    }

    public void setBaseTime(TimeAndUniq t) {
        this.baseTime = t;
    }

    public TimeAndUniq getBaseTime() {
        return this.baseTime;
    }

    class FamilyInfo
    implements SerializedFamilyInfo {
        KeyValue rootKV;
        int familyId;
        ByteWriter writer;
        FieldPath jsonPath;
        ByteBuffer cachedBuffer;
        InsertContext.OpType parentOpType;
        public InsertContext.OpType opType;
        public SerializationAction action;
        public KeyValue parentKV;

        public FamilyInfo() {
        }

        public FamilyInfo(int familyId, FieldPath jsonPath, ByteBuffer cachedBuffer) {
            this.familyId = familyId;
            this.jsonPath = jsonPath;
            this.cachedBuffer = cachedBuffer;
            this.action = this.cachedBuffer == null ? SerializationAction.NO_ACTION : SerializationAction.SET;
        }

        @Override
        public int getFamilyId() {
            return this.familyId;
        }

        @Override
        public SerializationAction getAction() {
            return this.action;
        }

        @Override
        public ByteBuffer getByteBuffer() {
            if (this.cachedBuffer != null) {
                return this.cachedBuffer;
            }
            if (this.writer == null) {
                return null;
            }
            return this.writer.getByteBuffer();
        }
    }
}

