/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.ControlInfoImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Types;

@API.Internal
public class DBDOMDocumentReader
implements DBDocumentReaderBase {
    private Stack<IteratorWithType> stateStack = new Stack();
    private IteratorWithType currentItr = null;
    private DocumentReader.EventType nextEvent = null;
    private DocumentReader.EventType currentEvent = null;
    private KeyValue dbValue;
    private Value rootKeyValue = null;
    private KeyValue idValue = null;

    public DBDOMDocumentReader(KeyValue value) {
        this(value, null);
    }

    public DBDOMDocumentReader(KeyValue value, KeyValue idValue) {
        this.dbValue = value;
        Value.Type type = value.getType();
        this.nextEvent = Types.getEventTypeForType((Value.Type)type);
        if (!type.isScalar()) {
            this.stateStack.push(new IteratorWithType(value));
        }
        this.rootKeyValue = value;
        this.idValue = idValue;
    }

    private void processNextNode() {
        if (this.stateStack.empty()) {
            this.nextEvent = null;
            return;
        }
        this.currentItr = this.stateStack.peek();
        if (this.currentItr.hasNext()) {
            Object o = this.currentItr.next();
            this.dbValue = this.inMap() ? (KeyValue)((Map.Entry)o).getValue() : KeyValueBuilder.initFromObject(o);
            this.nextEvent = Types.getEventTypeForType((Value.Type)this.dbValue.getType());
            if (!this.dbValue.getType().isScalar()) {
                this.stateStack.push(new IteratorWithType(this.dbValue));
            }
        } else {
            IteratorWithType iter = this.stateStack.pop();
            this.dbValue = iter.getValue();
            this.nextEvent = iter.getType() == Value.Type.MAP ? DocumentReader.EventType.END_MAP : DocumentReader.EventType.END_ARRAY;
            this.currentItr = this.stateStack.isEmpty() ? null : this.stateStack.peek();
        }
    }

    public DocumentReader.EventType next() {
        this.currentEvent = null;
        if (this.nextEvent != null) {
            this.currentEvent = this.nextEvent;
            this.nextEvent = null;
        } else {
            this.processNextNode();
            this.currentEvent = this.nextEvent;
            this.nextEvent = null;
        }
        return this.currentEvent;
    }

    private void checkEventType(DocumentReader.EventType event) throws TypeException {
        if (this.currentEvent != event) {
            throw new TypeException(String.format("Event type mismatch. The operation requires %s, but found %s", event, this.currentEvent));
        }
    }

    public boolean inMap() {
        return this.currentItr == null || this.currentItr.getType() == Value.Type.MAP;
    }

    public int getArrayIndex() {
        if (this.inMap()) {
            throw new IllegalStateException("Not traversing an array!");
        }
        return this.currentItr.previousIndex();
    }

    public String getFieldName() {
        if (!this.inMap()) {
            throw new IllegalStateException("Not traversing a map!");
        }
        return this.dbValue.getKey();
    }

    public byte getByte() {
        this.checkEventType(DocumentReader.EventType.BYTE);
        return this.dbValue.getByte();
    }

    public short getShort() {
        this.checkEventType(DocumentReader.EventType.SHORT);
        return this.dbValue.getShort();
    }

    public int getInt() {
        this.checkEventType(DocumentReader.EventType.INT);
        return this.dbValue.getInt();
    }

    public long getLong() {
        this.checkEventType(DocumentReader.EventType.LONG);
        return this.dbValue.getLong();
    }

    public float getFloat() {
        this.checkEventType(DocumentReader.EventType.FLOAT);
        return this.dbValue.getFloat();
    }

    public double getDouble() {
        this.checkEventType(DocumentReader.EventType.DOUBLE);
        return this.dbValue.getDouble();
    }

    public BigDecimal getDecimal() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.dbValue.getDecimal();
    }

    public int getDecimalPrecision() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.precision();
        }
        return 0;
    }

    public int getDecimalScale() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.scale();
        }
        return 0;
    }

    public int getDecimalValueAsInt() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.intValueExact();
        }
        return 0;
    }

    public long getDecimalValueAsLong() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.longValueExact();
        }
        return 0L;
    }

    public ByteBuffer getDecimalValueAsBytes() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            BigInteger decimalInteger = decimal.unscaledValue();
            byte[] bytearray = decimalInteger.toByteArray();
            return ByteBuffer.wrap(bytearray);
        }
        return null;
    }

    public boolean getBoolean() {
        this.checkEventType(DocumentReader.EventType.BOOLEAN);
        return this.dbValue.getBoolean();
    }

    public String getString() {
        this.checkEventType(DocumentReader.EventType.STRING);
        return this.dbValue.getString();
    }

    public long getTimestampLong() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.dbValue.getTimestampAsLong();
    }

    public OTimestamp getTimestamp() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.dbValue.getTimestamp();
    }

    public int getDateInt() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return this.dbValue.getDateAsInt();
    }

    public ODate getDate() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return this.dbValue.getDate();
    }

    public int getTimeInt() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return this.dbValue.getTimeAsInt();
    }

    public OTime getTime() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return this.dbValue.getTime();
    }

    public OInterval getInterval() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return this.dbValue.getInterval();
    }

    public int getIntervalDays() {
        return this.getInterval().getDays();
    }

    public long getIntervalMillis() {
        return this.getInterval().getTimeInMillis();
    }

    public ByteBuffer getBinary() {
        this.checkEventType(DocumentReader.EventType.BINARY);
        return this.dbValue.getBinary();
    }

    @Override
    public ControlInfo getControlInfo() {
        if (this.currentEvent == DocumentReader.EventType.END_MAP || this.currentEvent == DocumentReader.EventType.END_ARRAY) {
            throw new UnsupportedOperationException("Can not return timeDescriptor for eventType END_MAP or END_ARRAY");
        }
        byte timeDesc = this.dbValue != null ? this.dbValue.getTimeDescriptor() : ((KeyValue)this.rootKeyValue).getTimeDescriptor();
        return new ControlInfoImpl(timeDesc);
    }

    @Override
    public Value getId() {
        return this.idValue;
    }

    private class IteratorWithType
    implements ListIterator<Object> {
        final Iterator<?> i;
        final KeyValue value;

        IteratorWithType(KeyValue value) {
            this.value = value;
            this.i = value.getType() == Value.Type.MAP ? ((DBDocumentImpl)value).iterator() : ((DBList)value).listIterator();
        }

        public KeyValue getValue() {
            return this.value;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return (this.getType() == Value.Type.ARRAY ? "ListIterator@" : "MapIterator@") + this.hashCode();
        }

        Value.Type getType() {
            return this.value.getType();
        }

        @Override
        public boolean hasPrevious() {
            this.checkList();
            return ((ListIterator)this.i).hasPrevious();
        }

        @Override
        public Object previous() {
            this.checkList();
            return ((ListIterator)this.i).previous();
        }

        @Override
        public int nextIndex() {
            this.checkList();
            return ((ListIterator)this.i).nextIndex();
        }

        @Override
        public int previousIndex() {
            this.checkList();
            return ((ListIterator)this.i).previousIndex();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }

        private void checkList() {
            if (this.getType() != Value.Type.ARRAY) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

