/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.store.jdbc.JdbcExpressionCheck;

abstract class DrillJdbcRuleBase
extends ConverterRule {
    protected final LoadingCache<RexNode, Boolean> checkedExpressions = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<RexNode, Boolean>(){

        public Boolean load(RexNode expr) {
            return JdbcExpressionCheck.isOnlyStandardExpressions(expr);
        }
    });
    protected final JdbcConvention out;

    private DrillJdbcRuleBase(Class<? extends RelNode> clazz, RelTrait in, JdbcConvention out, String description) {
        super(clazz, in, (RelTrait)out, description);
        this.out = out;
    }

    static class DrillJdbcFilterRule
    extends DrillJdbcRuleBase {
        public DrillJdbcFilterRule(JdbcConvention out) {
            super(LogicalFilter.class, (RelTrait)Convention.NONE, out, "DrillJdbcFilterRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return new JdbcRules.JdbcFilter(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.out), DrillJdbcFilterRule.convert((RelNode)filter.getInput(), (RelTraitSet)filter.getInput().getTraitSet().replace((RelTrait)this.out)), filter.getCondition());
        }

        public boolean matches(RelOptRuleCall call) {
            try {
                LogicalFilter filter = (LogicalFilter)call.rel(0);
                for (RexNode node : filter.getChildExps()) {
                    if (((Boolean)this.checkedExpressions.get((Object)node)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failure while trying to evaluate pushdown.", e);
            }
        }
    }

    static class DrillJdbcProjectRule
    extends DrillJdbcRuleBase {
        public DrillJdbcProjectRule(JdbcConvention out) {
            super(LogicalProject.class, (RelTrait)Convention.NONE, out, "JdbcProjectRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new JdbcRules.JdbcProject(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.out), DrillJdbcProjectRule.convert((RelNode)project.getInput(), (RelTraitSet)project.getInput().getTraitSet().replace((RelTrait)this.out)), project.getProjects(), project.getRowType());
        }

        public boolean matches(RelOptRuleCall call) {
            try {
                LogicalProject project = (LogicalProject)call.rel(0);
                for (RexNode node : project.getChildExps()) {
                    if (((Boolean)this.checkedExpressions.get((Object)node)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failure while trying to evaluate pushdown.", e);
            }
        }
    }
}

