/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.mongo.MongoFilterBuilder;
import org.apache.drill.exec.store.mongo.MongoGroupScan;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPushDownFilterForScan
extends StoragePluginOptimizerRule {
    private static final Logger logger = LoggerFactory.getLogger(MongoPushDownFilterForScan.class);
    public static final StoragePluginOptimizerRule INSTANCE = new MongoPushDownFilterForScan();

    private MongoPushDownFilterForScan() {
        super(RelOptHelper.some(FilterPrel.class, (RelOptRuleOperand)RelOptHelper.any(ScanPrel.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "MongoPushDownFilterForScan");
    }

    public void onMatch(RelOptRuleCall call) {
        ScanPrel scan = (ScanPrel)call.rel(1);
        FilterPrel filter = (FilterPrel)call.rel(0);
        RexNode condition = filter.getCondition();
        MongoGroupScan groupScan = (MongoGroupScan)scan.getGroupScan();
        if (groupScan.isFilterPushedDown()) {
            return;
        }
        LogicalExpression conditionExp = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)call.getPlanner())), (RelNode)scan, (RexNode)condition);
        MongoFilterBuilder mongoFilterBuilder = new MongoFilterBuilder(groupScan, conditionExp);
        MongoScanSpec newScanSpec = mongoFilterBuilder.parseTree();
        if (newScanSpec == null) {
            return;
        }
        MongoGroupScan newGroupsScan = null;
        try {
            newGroupsScan = new MongoGroupScan(groupScan.getUserName(), groupScan.getStoragePlugin(), newScanSpec, groupScan.getColumns());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
        newGroupsScan.setFilterPushedDown(true);
        ScanPrel newScanPrel = ScanPrel.create((RelNode)scan, (RelTraitSet)filter.getTraitSet(), (GroupScan)newGroupsScan, (RelDataType)scan.getRowType());
        if (mongoFilterBuilder.isAllExpressionsConverted()) {
            call.transformTo((RelNode)newScanPrel);
        } else {
            call.transformTo(filter.copy(filter.getTraitSet(), (List)ImmutableList.of((Object)newScanPrel)));
        }
    }

    public boolean matches(RelOptRuleCall call) {
        ScanPrel scan = (ScanPrel)call.rel(1);
        if (scan.getGroupScan() instanceof MongoGroupScan) {
            return super.matches(call);
        }
        return false;
    }
}

