/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.impl.JsonDocumentStream;
import org.ojai.json.impl.JsonList;
import org.ojai.json.impl.JsonValue;
import org.ojai.json.impl.JsonValueBuilder;

@API.Internal
public class JsonDocumentIterator
implements Iterator<Document> {
    Iterator<DocumentReader> it = null;
    JsonDocument document;
    DocumentReader reader;
    private boolean done = false;

    public JsonDocumentIterator(JsonDocumentStream s) {
        this.it = s.documentReaders().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.done) {
            return false;
        }
        if (this.reader == null) {
            if (this.it.hasNext()) {
                this.reader = this.it.next();
            } else {
                this.done = true;
            }
        }
        return this.reader != null;
    }

    @Override
    public Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called after hasNext() returned false");
        }
        Document rec = this.getDocumentFromStreamReader();
        this.reader = null;
        return rec;
    }

    private Document getDocumentFromStreamReader() {
        DocumentReader.EventType event;
        Stack<JsonDocument> containerStack = new Stack<JsonDocument>();
        JsonDocument lastDocument = null;
        JsonValue currentContainer = null;
        block21: while ((event = this.reader.next()) != null) {
            switch (event) {
                case START_MAP: {
                    JsonDocument newRec = new JsonDocument();
                    if (currentContainer != null) {
                        this.appendTo(currentContainer, newRec);
                    }
                    currentContainer = newRec;
                    containerStack.push((JsonDocument)currentContainer);
                    continue block21;
                }
                case END_MAP: {
                    if (!containerStack.empty() && containerStack.peek() instanceof JsonDocument) {
                        lastDocument = (JsonDocument)containerStack.pop();
                        if (containerStack.empty()) continue block21;
                        currentContainer = (JsonValue)containerStack.peek();
                        continue block21;
                    }
                    throw new DecodingException("Unable to decode document stream: " + containerStack.toString());
                }
                case START_ARRAY: {
                    JsonList newList = new JsonList();
                    if (currentContainer != null) {
                        this.appendTo(currentContainer, newList);
                    }
                    currentContainer = newList;
                    containerStack.push((JsonDocument)currentContainer);
                    continue block21;
                }
                case END_ARRAY: {
                    if (!containerStack.empty() && containerStack.peek() instanceof JsonList) {
                        containerStack.pop();
                        if (containerStack.empty()) continue block21;
                        currentContainer = (JsonValue)containerStack.peek();
                        continue block21;
                    }
                    throw new DecodingException("Unable to decode document stream: " + containerStack.toString());
                }
                case NULL: {
                    this.appendTo(currentContainer, JsonValue.NULLKEYVALUE);
                    continue block21;
                }
                case BOOLEAN: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getBoolean()));
                    continue block21;
                }
                case BINARY: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getBinary()));
                    continue block21;
                }
                case BYTE: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getByte()));
                    continue block21;
                }
                case SHORT: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getShort()));
                    continue block21;
                }
                case INT: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getInt()));
                    continue block21;
                }
                case LONG: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getLong()));
                    continue block21;
                }
                case FLOAT: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getFloat()));
                    continue block21;
                }
                case DOUBLE: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getDouble()));
                    continue block21;
                }
                case DECIMAL: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getDecimal()));
                    continue block21;
                }
                case STRING: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getString()));
                    continue block21;
                }
                case DATE: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getDate()));
                    continue block21;
                }
                case TIME: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getTime()));
                    continue block21;
                }
                case TIMESTAMP: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getTimestamp()));
                    continue block21;
                }
                case INTERVAL: {
                    this.appendTo(currentContainer, JsonValueBuilder.initFrom(this.reader.getInterval()));
                    continue block21;
                }
            }
            throw new DecodingException("Unknown token type " + (Object)((Object)event) + " from stream reader");
        }
        if (!containerStack.empty()) {
            throw new DecodingException("Error processing document");
        }
        return lastDocument;
    }

    private void appendTo(JsonValue currentContainer, JsonValue value) {
        if (currentContainer instanceof JsonDocument) {
            value.setKey(this.reader.getFieldName());
            ((JsonDocument)currentContainer).getRootMap().put(this.reader.getFieldName(), value);
        } else if (currentContainer instanceof JsonList) {
            ((JsonList)currentContainer).add(this.reader.getArrayIndex(), value);
        } else {
            throw new DecodingException("Unable to decode document stream: " + currentContainer.toString());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

