/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.beans.BeanCodec;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.Events;
import org.ojai.json.JsonOptions;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.impl.JsonDocumentBuilder;
import org.ojai.json.impl.JsonDocumentStream;
import org.ojai.json.impl.JsonUtils;
import org.ojai.json.impl.JsonValueBuilder;

@API.Public
public final class Json {
    public static Document newDocument() {
        return new JsonDocument();
    }

    public static Document newDocument(String jsonString) throws DecodingException {
        try {
            ByteArrayInputStream jsonStream = new ByteArrayInputStream(JsonUtils.getBytes(jsonString));
            return Json.newDocumentStream(jsonStream).iterator().next();
        }
        catch (DecodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecodingException(e);
        }
    }

    public static Document newDocument(Object bean) throws DecodingException {
        return BeanCodec.decode(Json.newDocumentBuilder(), bean);
    }

    public static <T> Document newDocument(Map<String, T> map) throws DecodingException {
        return (Document)((Object)JsonValueBuilder.initFrom(map));
    }

    public static DocumentReader newDocumentReader(String jsonString) throws DecodingException {
        try {
            ByteArrayInputStream jsonStream = new ByteArrayInputStream(JsonUtils.getBytes(jsonString));
            return Json.newDocumentStream(jsonStream).documentReaders().iterator().next();
        }
        catch (DecodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecodingException(e);
        }
    }

    public static DocumentBuilder newDocumentBuilder() {
        return new JsonDocumentBuilder();
    }

    public static DocumentBuilder newDocumentBuilder(JsonOptions options) {
        return new JsonDocumentBuilder().setJsonOptions(options);
    }

    public static DocumentStream newDocumentStream(InputStream in) {
        return new JsonDocumentStream(in, null, null);
    }

    public static DocumentStream newDocumentStream(InputStream in, Map<FieldPath, Value.Type> fieldPathTypeMap) {
        return new JsonDocumentStream(in, fieldPathTypeMap, null);
    }

    public static DocumentStream newDocumentStream(InputStream in, Events.Delegate eventDelegate) {
        return new JsonDocumentStream(in, null, eventDelegate);
    }

    public static DocumentStream newDocumentStream(FileSystem fs, String path) throws DecodingException, IOException {
        return JsonDocumentStream.newDocumentStream(fs, path, null, null);
    }

    public static DocumentStream newDocumentStream(FileSystem fs, String path, Map<FieldPath, Value.Type> fieldPathTypeMap) throws DecodingException, IOException {
        return JsonDocumentStream.newDocumentStream(fs, path, fieldPathTypeMap, null);
    }

    public static DocumentStream newDocumentStream(FileSystem fs, String path, Events.Delegate eventDelegate) throws DecodingException, IOException {
        return JsonDocumentStream.newDocumentStream(fs, path, null, eventDelegate);
    }

    public static String toJsonString(Document d) {
        return Json.toJsonString(d.asReader(), JsonOptions.DEFAULT);
    }

    public static String toJsonString(Document d, JsonOptions options) {
        return Json.toJsonString(d.asReader(), options);
    }

    public static String toJsonString(DocumentReader r) {
        return Json.toJsonString(r, JsonOptions.DEFAULT);
    }

    public static String toJsonString(DocumentReader r, JsonOptions options) {
        JsonDocumentBuilder builder = new JsonDocumentBuilder().setJsonOptions(options);
        DocumentReader.EventType e = r.next();
        switch (e) {
            case START_MAP: {
                builder.addNewMap();
                JsonUtils.addToMap(r, builder);
                break;
            }
            case START_ARRAY: {
                builder.setCheckContext(false).addNewArray().setCheckContext(true);
                JsonUtils.addToArray(r, builder);
                break;
            }
            default: {
                JsonUtils.addReaderEvent(e, r, builder.setCheckContext(false));
            }
        }
        return builder.asUTF8String();
    }

    public static void writeReaderToBuilder(DocumentReader r, DocumentBuilder w) {
        JsonUtils.addToMap(r, w);
    }
}

