/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.beans;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.beans.jackson.DocumentGenerator;
import org.ojai.beans.jackson.DocumentParser;
import org.ojai.beans.jackson.JacksonHelper;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;

@API.Public
public class BeanCodec {
    public static Document decode(DocumentBuilder db, Object bean) throws DecodingException {
        if (bean == null) {
            return null;
        }
        DocumentGenerator gen = new DocumentGenerator(db);
        try {
            JacksonHelper.MAPPER.writeValue((JsonGenerator)gen, bean);
            return gen.getDocument();
        }
        catch (Exception e) {
            throw new DecodingException("Failed to convert the java bean to Document", e);
        }
    }

    public static <T> T encode(DocumentReader dr, Class<T> beanClass) throws EncodingException {
        if (dr == null) {
            return null;
        }
        try {
            return (T)JacksonHelper.MAPPER.readValue((JsonParser)new DocumentParser(dr), beanClass);
        }
        catch (IOException e) {
            throw new EncodingException("Failed to create java bean from Document", e);
        }
    }
}

