/*
 * Decompiled with CFR 0.152.
 */
package org.ojai;

import org.ojai.annotation.API;
import org.ojai.util.Fields;

@API.Public
public abstract class FieldSegment
implements Comparable<FieldSegment> {
    protected final FieldSegment child;
    protected final Type type;
    protected int hash;

    protected FieldSegment(FieldSegment child) {
        this.child = child;
        this.type = child == null ? Type.LEAF : (child.isIndexed() ? Type.ARRAY : Type.MAP);
    }

    public boolean isMap() {
        return this.type == Type.MAP;
    }

    public boolean isArray() {
        return this.type == Type.ARRAY;
    }

    public boolean isLeaf() {
        return this.type == Type.LEAF;
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean isNamed() {
        return false;
    }

    abstract FieldSegment cloneWithNewChild(FieldSegment var1);

    abstract int segmentCompareTo(FieldSegment var1);

    public abstract FieldSegment clone();

    public NameSegment getNameSegment() {
        throw new UnsupportedOperationException();
    }

    public IndexSegment getIndexSegment() {
        throw new UnsupportedOperationException();
    }

    protected abstract StringBuilder writeSegment(StringBuilder var1, boolean var2);

    public final String toString() {
        return this.asPathString(true);
    }

    final String asPathString(boolean quote) {
        StringBuilder sb = new StringBuilder();
        FieldSegment seg = this;
        seg.writeSegment(sb, quote);
        while ((seg = seg.getChild()) != null) {
            if (seg.isNamed()) {
                sb.append('.');
            }
            seg.writeSegment(sb, quote);
        }
        return sb.toString();
    }

    public boolean isLastPath() {
        return this.child == null;
    }

    public FieldSegment getChild() {
        return this.child;
    }

    protected abstract int segmentHashCode();

    protected abstract boolean segmentEquals(FieldSegment var1);

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.segmentHashCode();
            this.hash = h = 31 * h + (this.child == null ? 0 : this.child.hashCode());
        }
        return h;
    }

    @Override
    public int compareTo(FieldSegment other) {
        int cmp = this.segmentCompareTo(other);
        if (cmp != 0) {
            return cmp;
        }
        if (this.child == null) {
            return other.child == null ? 0 : -1;
        }
        return this.child.compareTo(other.child);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSegment other = (FieldSegment)obj;
        if (!this.segmentEquals(other)) {
            return false;
        }
        if (this.child == null) {
            return other.child == null;
        }
        return this.child.equals(other.child);
    }

    public boolean contains(FieldSegment otherSeg) {
        if (this == otherSeg) {
            return true;
        }
        if (otherSeg == null) {
            return false;
        }
        if (otherSeg.isIndexed() || this.isIndexed()) {
            return true;
        }
        if (this.getClass() != otherSeg.getClass()) {
            return false;
        }
        if (!this.segmentEquals(otherSeg)) {
            return false;
        }
        if (this.child == null || otherSeg.child == null) {
            return true;
        }
        return this.child.contains(otherSeg.child);
    }

    boolean isAtOrBelow(FieldSegment otherSeg) {
        if (this == otherSeg || otherSeg == null) {
            return true;
        }
        if (!this.segmentEquals(otherSeg)) {
            return false;
        }
        if (this.child != null) {
            return this.child.isAtOrBelow(otherSeg.child);
        }
        return otherSeg.child == null;
    }

    boolean isAtOrAbove(FieldSegment otherSeg) {
        if (this == otherSeg) {
            return true;
        }
        if (otherSeg == null || !this.segmentEquals(otherSeg)) {
            return false;
        }
        if (this.child != null) {
            return this.child.isAtOrAbove(otherSeg.child);
        }
        return true;
    }

    @API.Internal
    public static final class NameSegment
    extends FieldSegment {
        private final String name;
        private final boolean isQuoted;

        NameSegment(String n) {
            super(null);
            this.name = Fields.unquoteFieldName(n);
            this.isQuoted = this.name != n;
        }

        public NameSegment(String n, FieldSegment child, boolean quoted) {
            super(child);
            this.name = n;
            this.isQuoted = quoted;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNamed() {
            return true;
        }

        @Override
        protected int segmentCompareTo(FieldSegment o) {
            if (o instanceof NameSegment) {
                NameSegment that = (NameSegment)o;
                return this.name.compareTo(that.name);
            }
            return 1;
        }

        @Override
        public NameSegment getNameSegment() {
            return this;
        }

        @Override
        protected int segmentHashCode() {
            return this.name == null ? 0 : this.name.toLowerCase().hashCode();
        }

        @Override
        protected boolean segmentEquals(FieldSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameSegment other = (NameSegment)obj;
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equalsIgnoreCase(other.name);
        }

        @Override
        public NameSegment clone() {
            return new NameSegment(this.name, this.child != null ? this.child.clone() : null, this.isQuoted);
        }

        @Override
        NameSegment cloneWithNewChild(FieldSegment newChild) {
            return new NameSegment(this.name, this.child != null ? this.child.cloneWithNewChild(newChild) : newChild, this.isQuoted);
        }

        @Override
        protected StringBuilder writeSegment(StringBuilder sb, boolean quote) {
            if (quote || this.isQuoted) {
                sb.append(Fields.SEGMENT_QUOTE_CHAR);
            }
            this.escape(sb, quote);
            if (quote || this.isQuoted) {
                sb.append(Fields.SEGMENT_QUOTE_CHAR);
            }
            return sb;
        }

        protected StringBuilder escape(StringBuilder sb, boolean quote) {
            block9: for (int i = 0; i < this.name.length(); ++i) {
                char ch = this.name.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '\\': 
                    case '`': {
                        sb.append('\\').append(ch);
                        continue block9;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block9;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    case '.': 
                    case '[': 
                    case ']': {
                        if (!quote && !this.isQuoted) {
                            sb.append('\\');
                        }
                    }
                    default: {
                        sb.append(ch >= ' ' ? Character.valueOf(ch) : String.format("\\u%04X", ch));
                    }
                }
            }
            return sb;
        }

        public static String unEscape(String rawString) {
            boolean inEscape = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < rawString.length(); ++i) {
                char ch = rawString.charAt(i);
                if (inEscape) {
                    switch (ch) {
                        case 'u': {
                            if (i + 4 >= rawString.length()) {
                                throw new IllegalArgumentException(String.format("Illegal unicode sequnce found in string '%s' at position %d", rawString, i - 1));
                            }
                            sb.append((char)Integer.parseInt(rawString.substring(i + 1, i + 5), 16));
                            i += 4;
                            break;
                        }
                        case '\"': 
                        case '.': 
                        case '/': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '`': {
                            sb.append(ch);
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Illegal escape char %c found in string '%s' at position %d", Character.valueOf(ch), rawString, i - 1));
                        }
                    }
                    inEscape = false;
                    continue;
                }
                if (ch == '\\') {
                    inEscape = true;
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static String unQuote(String rawString) {
            if (rawString == null || rawString.length() < 2 || "\"`".indexOf(rawString.charAt(0)) == -1 || "\"`".indexOf(rawString.charAt(rawString.length() - 1)) == -1) {
                throw new IllegalArgumentException(String.format("%s is not a valid quoted identifier.", rawString));
            }
            return NameSegment.unEscape(rawString.substring(1, rawString.length() - 1));
        }
    }

    @API.Internal
    public static final class IndexSegment
    extends FieldSegment {
        private final int index;

        IndexSegment(int index) {
            this(index, null);
        }

        public IndexSegment(String numberAsText, FieldSegment child) {
            this(numberAsText == null ? -1 : Integer.parseInt(numberAsText), child);
        }

        IndexSegment(FieldSegment child) {
            this(-1, child);
        }

        IndexSegment(int index, FieldSegment child) {
            super(child);
            if (index < -1) {
                throw new IllegalArgumentException();
            }
            this.index = index;
        }

        public boolean hasIndex() {
            return this.index != -1;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isIndexed() {
            return true;
        }

        @Override
        public IndexSegment getIndexSegment() {
            return this;
        }

        @Override
        protected int segmentHashCode() {
            return this.index;
        }

        @Override
        protected int segmentCompareTo(FieldSegment other) {
            if (other instanceof IndexSegment) {
                IndexSegment that = (IndexSegment)other;
                return this.index - that.index;
            }
            return other == null ? 1 : -1;
        }

        @Override
        protected boolean segmentEquals(FieldSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof IndexSegment) {
                return this.index == ((IndexSegment)obj).getIndex();
            }
            return false;
        }

        @Override
        public FieldSegment clone() {
            FieldSegment clonedChild = this.child != null ? this.child.clone() : null;
            return this.index < 0 ? new IndexSegment(clonedChild) : new IndexSegment(this.index, clonedChild);
        }

        @Override
        IndexSegment cloneWithNewChild(FieldSegment newChild) {
            FieldSegment clonedChild = this.child != null ? this.child.cloneWithNewChild(newChild) : newChild;
            return this.index < 0 ? new IndexSegment(clonedChild) : new IndexSegment(this.index, clonedChild);
        }

        @Override
        protected StringBuilder writeSegment(StringBuilder sb, boolean quote) {
            sb.append('[');
            if (this.index >= 0) {
                sb.append(this.index);
            }
            sb.append(']');
            return sb;
        }
    }

    protected static enum Type {
        MAP,
        ARRAY,
        LEAF;

    }
}

