/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSizeCalculator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class RangeChecksumInputFormat
extends TableInputFormat {
    public static final String SPLITFILENAME = "splitfilename";
    public static final String INCLUDEDREGIONFILENAME = "includedregionfilename";
    private static final Log LOG = LogFactory.getLog(RangeChecksumInputFormat.class);
    private String splitFileName = null;
    private String includedRegionStartPointsFileName = null;
    private List<ImmutableBytesWritable> splitPoints = null;
    private List<ImmutableBytesWritable> includedRegionStartPoints = null;
    private TreeSet<ImmutableBytesWritable> searchableSplitPoints = null;
    private TreeSet<ImmutableBytesWritable> searchableIncludedRegionStartPoints = null;

    public void setConf(Configuration configuration) {
        this.splitFileName = configuration.get(SPLITFILENAME, null);
        if (this.splitFileName != null) {
            try {
                Path splitFilePath = new Path(this.splitFileName);
                this.splitPoints = SegKeyRangeUtil.readKeyRange(configuration, splitFilePath);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read  file " + this.splitFileName + " ", ie);
            }
        }
        this.includedRegionStartPointsFileName = configuration.get(INCLUDEDREGIONFILENAME, null);
        if (this.includedRegionStartPointsFileName != null) {
            try {
                Path includedRegionStartPointsFilePath = new Path(this.includedRegionStartPointsFileName);
                this.includedRegionStartPoints = SegKeyRangeUtil.readKeyRange(configuration, includedRegionStartPointsFilePath);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read  file " + this.includedRegionStartPointsFileName + " ", ie);
            }
        }
        super.setConf(configuration);
    }

    public ImmutableBytesWritable getSplitStartKey(ImmutableBytesWritable key) {
        ImmutableBytesWritable ret;
        if (this.splitPoints == null) {
            throw new IllegalArgumentException("splitPoints are null from file " + this.splitFileName);
        }
        if (this.searchableSplitPoints == null) {
            this.searchableSplitPoints = new TreeSet<ImmutableBytesWritable>(this.splitPoints);
        }
        if ((ret = this.searchableSplitPoints.floor(key)) == null) {
            ret = this.splitPoints.get(0);
            LOG.error((Object)("key " + Bytes.toStringBinary((byte[])key.get()) + " does not belong to a range. " + "Return first range start key " + Bytes.toStringBinary((byte[])ret.get())));
        }
        return ret;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        if (this.includedRegionStartPoints == null) {
            return true;
        }
        if (this.searchableIncludedRegionStartPoints == null) {
            this.searchableIncludedRegionStartPoints = new TreeSet<ImmutableBytesWritable>(this.includedRegionStartPoints);
        }
        ImmutableBytesWritable skey = new ImmutableBytesWritable(startKey);
        boolean ret = this.searchableIncludedRegionStartPoints.contains(skey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startKey = (" + Bytes.toStringBinary((byte[])startKey) + "), endKey = (" + Bytes.toStringBinary((byte[])endKey) + ")," + " searchableIncludedRegionStartPoints contains startKey = (" + Boolean.toString(ret) + ")"));
        }
        return ret;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        if (this.splitPoints == null) {
            return super.getSplits(context);
        }
        Configuration conf = this.getConf();
        String tableName = conf.get("hbase.mapreduce.inputtable");
        conf.set("default.db", "unsetDB");
        HTable table = new HTable(conf, tableName);
        if (table == null) {
            throw new IOException("No table was provided.");
        }
        RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(table);
        Pair<byte[][], byte[][]> keys = SegKeyRangeUtil.GenStartEndKeys(this.splitPoints);
        LOG.debug((Object)("startkeys.length=" + Integer.toString(((byte[][])keys.getFirst()).length) + " endkeys.length=" + Integer.toString(((byte[][])keys.getSecond()).length) + "  RangeChecksumInputFormat.startEndKeys:"));
        SegKeyRangeUtil.logStartEndKeys(keys);
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            HRegionLocation regLoc = table.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY, false);
            if (null == regLoc) {
                throw new IOException("Expecting at least one region.");
            }
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(1);
            long regionSize = sizeCalculator.getRegionSize(regLoc.getRegionInfo().getRegionName());
            TableSplit split = new TableSplit(table.getName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, regLoc.getHostnamePort().split(":")[0], regionSize);
            splits.add((InputSplit)split);
            LOG.debug((Object)("getSplits: split -> 0 -> " + split));
            return splits;
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(((byte[][])keys.getFirst()).length);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            String regionLocation;
            if (!this.includeRegionInSplit(((byte[][])keys.getFirst())[i], ((byte[][])keys.getSecond())[i])) {
                LOG.debug((Object)("Range " + i + " : (" + Bytes.toStringBinary((byte[])((byte[][])keys.getFirst())[i]) + "," + Bytes.toStringBinary((byte[])((byte[][])keys.getSecond())[i]) + ") is NOT included"));
                continue;
            }
            LOG.info((Object)("Range " + i + " : (" + Bytes.toStringBinary((byte[])((byte[][])keys.getFirst())[i]) + "," + Bytes.toStringBinary((byte[])((byte[][])keys.getSecond())[i]) + ") is included"));
            HRegionLocation location = table.getRegionLocation(((byte[][])keys.getFirst())[i], false);
            InetSocketAddress isa = new InetSocketAddress(location.getHostname(), location.getPort());
            if (isa.isUnresolved()) {
                LOG.warn((Object)("Failed resolve " + isa));
            }
            InetAddress regionAddress = isa.getAddress();
            try {
                regionLocation = this.reverseDNS(regionAddress);
            }
            catch (NamingException e) {
                LOG.warn((Object)("Cannot resolve the host name for " + regionAddress + " because of " + e));
                regionLocation = location.getHostname();
            }
            byte[] startRow = super.getScan().getStartRow();
            byte[] stopRow = super.getScan().getStopRow();
            if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
            byte[] regionName = location.getRegionInfo().getRegionName();
            long regionSize = sizeCalculator.getRegionSize(regionName);
            TableSplit split = new TableSplit(table.getName(), splitStart, splitStop, regionLocation, regionSize);
            splits.add((InputSplit)split);
            LOG.debug((Object)("getSplits: split -> " + i + " -> " + split));
        }
        return splits;
    }
}

