/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.plan.volcano.RelSubset;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.rules.MultiJoin;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSort;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class PlanModifierForASTConv {
    private static final Log LOG = LogFactory.getLog(PlanModifierForASTConv.class);

    public static RelNode convertOpTree(RelNode rel, List<FieldSchema> resultSchema) throws CalciteSemanticException {
        RelNode newTopNode = rel;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Original plan for PlanModifier\n " + RelOptUtil.toString(newTopNode)));
        }
        if (!(newTopNode instanceof Project) && !(newTopNode instanceof Sort)) {
            newTopNode = PlanModifierForASTConv.introduceDerivedTable(newTopNode);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Plan after top-level introduceDerivedTable\n " + RelOptUtil.toString(newTopNode)));
            }
        }
        PlanModifierForASTConv.convertOpTree(newTopNode, (RelNode)null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plan after nested convertOpTree\n " + RelOptUtil.toString(newTopNode)));
        }
        Pair<RelNode, RelNode> topSelparentPair = HiveCalciteUtil.getTopLevelSelect(newTopNode);
        PlanModifierUtil.fixTopOBSchema(newTopNode, topSelparentPair, resultSchema, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plan after fixTopOBSchema\n " + RelOptUtil.toString(newTopNode)));
        }
        topSelparentPair = HiveCalciteUtil.getTopLevelSelect(newTopNode);
        newTopNode = PlanModifierForASTConv.renameTopLevelSelectInResultSchema(newTopNode, topSelparentPair, resultSchema);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Final plan after modifier\n " + RelOptUtil.toString(newTopNode)));
        }
        return newTopNode;
    }

    private static String getTblAlias(RelNode rel) {
        if (null == rel) {
            return null;
        }
        if (rel instanceof HiveTableScan) {
            return ((HiveTableScan)rel).getTableAlias();
        }
        if (rel instanceof Project) {
            return null;
        }
        if (rel.getInputs().size() == 1) {
            return PlanModifierForASTConv.getTblAlias(rel.getInput(0));
        }
        return null;
    }

    private static void convertOpTree(RelNode rel, RelNode parent) {
        if (rel instanceof HepRelVertex) {
            throw new RuntimeException("Found HepRelVertex");
        }
        if (rel instanceof Join) {
            String leftChild;
            if (!PlanModifierForASTConv.validJoinParent(rel, parent)) {
                PlanModifierForASTConv.introduceDerivedTable(rel, parent);
            }
            if (null != (leftChild = PlanModifierForASTConv.getTblAlias(((Join)rel).getLeft())) && leftChild.equalsIgnoreCase(PlanModifierForASTConv.getTblAlias(((Join)rel).getRight()))) {
                PlanModifierForASTConv.introduceDerivedTable(((Join)rel).getLeft(), rel);
            }
        } else {
            if (rel instanceof MultiJoin) {
                throw new RuntimeException("Found MultiJoin");
            }
            if (rel instanceof RelSubset) {
                throw new RuntimeException("Found RelSubset");
            }
            if (rel instanceof SetOp) {
                if (!PlanModifierForASTConv.validSetopParent(rel, parent)) {
                    PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                }
                SetOp setop = (SetOp)rel;
                for (RelNode inputRel : setop.getInputs()) {
                    if (PlanModifierForASTConv.validSetopChild(inputRel)) continue;
                    PlanModifierForASTConv.introduceDerivedTable(inputRel, setop);
                }
            } else if (rel instanceof SingleRel) {
                if (rel instanceof Filter) {
                    if (!PlanModifierForASTConv.validFilterParent(rel, parent)) {
                        PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                } else if (rel instanceof HiveSort) {
                    if (!PlanModifierForASTConv.validSortParent(rel, parent)) {
                        PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                    if (!PlanModifierForASTConv.validSortChild((HiveSort)rel)) {
                        PlanModifierForASTConv.introduceDerivedTable(((HiveSort)rel).getInput(), rel);
                    }
                } else if (rel instanceof HiveAggregate) {
                    RelNode newParent = parent;
                    if (!PlanModifierForASTConv.validGBParent(rel, parent)) {
                        newParent = PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                    if (PlanModifierForASTConv.isEmptyGrpAggr(rel)) {
                        PlanModifierForASTConv.replaceEmptyGroupAggr(rel, newParent);
                    }
                }
            }
        }
        List<RelNode> childNodes = rel.getInputs();
        if (childNodes != null) {
            for (RelNode r : childNodes) {
                PlanModifierForASTConv.convertOpTree(r, rel);
            }
        }
    }

    private static RelNode renameTopLevelSelectInResultSchema(RelNode rootRel, Pair<RelNode, RelNode> topSelparentPair, List<FieldSchema> resultSchema) throws CalciteSemanticException {
        RelNode parentOforiginalProjRel = topSelparentPair.getKey();
        HiveProject originalProjRel = (HiveProject)topSelparentPair.getValue();
        List<RexNode> rootChildExps = originalProjRel.getChildExps();
        if (resultSchema.size() != rootChildExps.size()) {
            LOG.error((Object)PlanModifierUtil.generateInvalidSchemaMessage(originalProjRel, resultSchema, 0));
            throw new CalciteSemanticException("Result Schema didn't match Optimized Op Tree Schema");
        }
        ArrayList<String> newSelAliases = new ArrayList<String>();
        for (int i = 0; i < rootChildExps.size(); ++i) {
            String colAlias = resultSchema.get(i).getName();
            if (colAlias.startsWith("_")) {
                colAlias = colAlias.substring(1);
            }
            newSelAliases.add(colAlias);
        }
        HiveProject replacementProjectRel = HiveProject.create(originalProjRel.getInput(), originalProjRel.getChildExps(), newSelAliases);
        if (rootRel == originalProjRel) {
            return replacementProjectRel;
        }
        parentOforiginalProjRel.replaceInput(0, replacementProjectRel);
        return rootRel;
    }

    private static RelNode introduceDerivedTable(RelNode rel) {
        List<RexNode> projectList = HiveCalciteUtil.getProjsFromBelowAsInputRef(rel);
        HiveProject select = HiveProject.create(rel.getCluster(), rel, projectList, rel.getRowType(), rel.getCollationList());
        return select;
    }

    private static RelNode introduceDerivedTable(RelNode rel, RelNode parent) {
        int i = 0;
        int pos = -1;
        List<RelNode> childList = parent.getInputs();
        for (RelNode child : childList) {
            if (child == rel) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            throw new RuntimeException("Couldn't find child node in parent's inputs");
        }
        RelNode select = PlanModifierForASTConv.introduceDerivedTable(rel);
        parent.replaceInput(pos, select);
        return select;
    }

    private static boolean validJoinParent(RelNode joinNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof Join) {
            if (((Join)parent).getRight() == joinNode) {
                validParent = false;
            }
        } else if (parent instanceof SetOp) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validFilterParent(RelNode filterNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof Filter || parent instanceof Join || parent instanceof SetOp) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validGBParent(RelNode gbNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof Join || parent instanceof SetOp || parent instanceof Aggregate || parent instanceof Filter && ((Aggregate)gbNode).getGroupSet().isEmpty()) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validSortParent(RelNode sortNode, RelNode parent) {
        boolean validParent = true;
        if (!(parent == null || parent instanceof Project || parent instanceof Sort || HiveCalciteUtil.orderRelNode(parent))) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validSortChild(HiveSort sortNode) {
        boolean validChild = true;
        RelNode child = sortNode.getInput();
        if (!(HiveCalciteUtil.limitRelNode(sortNode) && HiveCalciteUtil.orderRelNode(child) || child instanceof Project)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean validSetopParent(RelNode setop, RelNode parent) {
        boolean validChild = true;
        if (parent != null && !(parent instanceof Project)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean validSetopChild(RelNode setopChild) {
        boolean validChild = true;
        if (!(setopChild instanceof Project)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean isEmptyGrpAggr(RelNode gbNode) {
        Aggregate aggrnode = (Aggregate)gbNode;
        return aggrnode.getGroupSet().isEmpty() && aggrnode.getAggCallList().isEmpty();
    }

    private static void replaceEmptyGroupAggr(RelNode rel, RelNode parent) {
        List<RexNode> exps = parent.getChildExps();
        for (RexNode rexNode : exps) {
            if (rexNode.accept(new HiveCalciteUtil.ConstantFinder()).booleanValue()) continue;
            throw new RuntimeException("We expect " + parent.toString() + " to contain only constants. However, " + rexNode.toString() + " is " + (Object)((Object)rexNode.getKind()));
        }
        HiveAggregate oldAggRel = (HiveAggregate)rel;
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RelDataType longType = TypeConverter.convert(TypeInfoFactory.longTypeInfo, typeFactory);
        RelDataType intType = TypeConverter.convert(TypeInfoFactory.intTypeInfo, typeFactory);
        SqlAggFunction countFn = SqlFunctionConverter.getCalciteAggFn("count", ImmutableList.of(intType), longType);
        ImmutableList<Integer> argList = ImmutableList.of(Integer.valueOf(0));
        AggregateCall dummyCall = new AggregateCall(countFn, false, argList, longType, null);
        Aggregate newAggRel = oldAggRel.copy(oldAggRel.getTraitSet(), oldAggRel.getInput(), oldAggRel.indicator, oldAggRel.getGroupSet(), oldAggRel.getGroupSets(), ImmutableList.of(dummyCall));
        RelNode select = PlanModifierForASTConv.introduceDerivedTable(newAggRel);
        parent.replaceInput(0, select);
    }
}

