/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;

public class FilterSelectivityEstimator
extends RexVisitorImpl<Double> {
    private final RelNode childRel;
    private final double childCardinality;

    protected FilterSelectivityEstimator(RelNode childRel) {
        super(true);
        this.childRel = childRel;
        this.childCardinality = RelMetadataQuery.getRowCount(childRel);
    }

    public Double estimateSelectivity(RexNode predicate) {
        return predicate.accept(this);
    }

    @Override
    public Double visitCall(RexCall call) {
        if (!this.deep) {
            return 1.0;
        }
        if (this.isPartitionPredicate(call, this.childRel)) {
            return 1.0;
        }
        Double selectivity = null;
        SqlKind op = this.getOp(call);
        switch (op) {
            case AND: {
                selectivity = this.computeConjunctionSelectivity(call);
                break;
            }
            case OR: {
                selectivity = this.computeDisjunctionSelectivity(call);
                break;
            }
            case NOT: 
            case NOT_EQUALS: {
                selectivity = this.computeNotEqualitySelectivity(call);
                break;
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                selectivity = 0.3333333333333333;
                break;
            }
            case IN: {
                selectivity = this.computeFunctionSelectivity(call) * (double)(call.operands.size() - 1);
                if (selectivity <= 0.0) {
                    selectivity = 0.1;
                    break;
                }
                if (!(selectivity >= 1.0)) break;
                selectivity = 1.0;
                break;
            }
            default: {
                selectivity = this.computeFunctionSelectivity(call);
            }
        }
        return selectivity;
    }

    private Double computeNotEqualitySelectivity(RexCall call) {
        double tmpNDV = this.getMaxNDV(call);
        if (tmpNDV > 1.0) {
            return (tmpNDV - 1.0) / tmpNDV;
        }
        return 1.0;
    }

    private Double computeFunctionSelectivity(RexCall call) {
        return 1.0 / this.getMaxNDV(call);
    }

    private Double computeDisjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode dje : call.getOperands()) {
            Double tmpCardinality;
            Double tmpSelectivity = dje.accept(this);
            if (tmpSelectivity == null) {
                tmpSelectivity = 0.99;
            }
            tmpSelectivity = (tmpCardinality = Double.valueOf(this.childCardinality * tmpSelectivity)) > 1.0 && tmpCardinality < this.childCardinality ? Double.valueOf(1.0 - tmpCardinality / this.childCardinality) : Double.valueOf(1.0);
            selectivity *= tmpSelectivity.doubleValue();
        }
        if (selectivity < 0.0) {
            selectivity = 0.0;
        }
        return 1.0 - selectivity;
    }

    private Double computeConjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode cje : call.getOperands()) {
            Double tmpSelectivity = cje.accept(this);
            if (tmpSelectivity == null) continue;
            selectivity *= tmpSelectivity.doubleValue();
        }
        return selectivity;
    }

    private Double getMaxNDV(RexCall call) {
        double maxNDV = 1.0;
        for (RexNode op : call.getOperands()) {
            double tmpNDV;
            if (op instanceof RexInputRef) {
                tmpNDV = HiveRelMdDistinctRowCount.getDistinctRowCount(this.childRel, ((RexInputRef)op).getIndex());
                if (!(tmpNDV > maxNDV)) continue;
                maxNDV = tmpNDV;
                continue;
            }
            RelOptUtil.InputReferencedVisitor irv = new RelOptUtil.InputReferencedVisitor();
            irv.apply(op);
            for (Integer childProjIndx : irv.inputPosReferenced) {
                tmpNDV = HiveRelMdDistinctRowCount.getDistinctRowCount(this.childRel, childProjIndx);
                if (!(tmpNDV > maxNDV)) continue;
                maxNDV = tmpNDV;
            }
        }
        return maxNDV;
    }

    private boolean isPartitionPredicate(RexNode expr, RelNode r) {
        if (r instanceof Project) {
            expr = RelOptUtil.pushFilterPastProject(expr, (Project)r);
            return this.isPartitionPredicate(expr, ((Project)r).getInput());
        }
        if (r instanceof Filter) {
            return this.isPartitionPredicate(expr, ((Filter)r).getInput());
        }
        if (r instanceof HiveTableScan) {
            RelOptHiveTable table = (RelOptHiveTable)((HiveTableScan)r).getTable();
            ImmutableBitSet cols = RelOptUtil.InputFinder.bits(expr);
            return table.containsPartitionColumnsOnly(cols);
        }
        return false;
    }

    private SqlKind getOp(RexCall call) {
        SqlKind op = call.getKind();
        if (call.getKind().equals((Object)SqlKind.OTHER_FUNCTION) && SqlTypeUtil.inBooleanFamily(call.getType())) {
            String opName;
            SqlOperator sqlOp = call.getOperator();
            String string = opName = sqlOp != null ? sqlOp.getName() : "";
            if (opName.equalsIgnoreCase("in")) {
                op = SqlKind.IN;
            }
        }
        return op;
    }
}

