/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.com.google.common.collect.ImmutableMap;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rex.RexNode;
import java.util.Map;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveSort
extends Sort
implements HiveRelNode {
    public static final HiveSortRelFactory HIVE_SORT_REL_FACTORY = new HiveSortRelFactory();
    private ImmutableMap<Integer, RexNode> mapOfInputRefToRexCall;

    public HiveSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, TraitsUtil.getSortTraitSet(cluster, traitSet, collation), child, collation, offset, fetch);
    }

    @Override
    public HiveSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        RelCollation canonizedCollation = traitSet.canonize(newCollation);
        return new HiveSort(this.getCluster(), traitSet, newInput, canonizedCollation, offset, fetch);
    }

    public RexNode getFetchExpr() {
        return this.fetch;
    }

    public void setInputRefToCallMap(ImmutableMap<Integer, RexNode> refToCall) {
        this.mapOfInputRefToRexCall = refToCall;
    }

    public Map<Integer, RexNode> getInputRefToCallMap() {
        return this.mapOfInputRefToRexCall;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    private static class HiveSortRelFactory
    implements RelFactories.SortFactory {
        private HiveSortRelFactory() {
        }

        @Override
        public RelNode createSort(RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            return new HiveSort(child.getCluster(), traits, child, collation, offset, fetch);
        }
    }
}

