/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import hive.parquet.hadoop.ParquetWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types", "hive.parquet.compression"})
public class ParquetHiveSerDe
extends AbstractSerDe {
    public static final Text MAP_KEY = new Text("key");
    public static final Text MAP_VALUE = new Text("value");
    public static final Text MAP = new Text("map");
    public static final Text ARRAY = new Text("bag");
    private static final String DEFAULTCOMPRESSION = ParquetWriter.DEFAULT_COMPRESSION_CODEC_NAME.name();
    public static final int[] PRECISION_TO_BYTE_COUNT = new int[38];
    private SerDeStats stats;
    private ObjectInspector objInspector;
    private LAST_OPERATION status;
    private long serializedSize;
    private long deserializedSize;
    private String compressionType;
    private ParquetHiveRecord parquetRow = new ParquetHiveRecord();

    public ParquetHiveSerDe() {
        this.stats = new SerDeStats();
    }

    @Override
    public final void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.compressionType = tbl.getProperty("hive.parquet.compression", DEFAULTCOMPRESSION);
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
        ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("ParquetHiveSerde initialization failed. Number of column name and column type differs. columnNames = " + columnNames + ", columnTypes = " + columnTypes);
        }
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.objInspector = new ArrayWritableObjectInspector((StructTypeInfo)rowTypeInfo);
        this.serializedSize = 0L;
        this.deserializedSize = 0L;
        this.status = LAST_OPERATION.UNKNOWN;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        this.status = LAST_OPERATION.DESERIALIZE;
        this.deserializedSize = 0L;
        if (blob instanceof ArrayWritable) {
            this.deserializedSize = ((ArrayWritable)blob).get().length;
            return blob;
        }
        return null;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return ParquetHiveRecord.class;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serialize " + (Object)((Object)objInspector.getCategory()) + ". Can only serialize a struct");
        }
        this.serializedSize = ((StructObjectInspector)objInspector).getAllStructFieldRefs().size();
        this.status = LAST_OPERATION.SERIALIZE;
        this.parquetRow.value = obj;
        this.parquetRow.inspector = (StructObjectInspector)objInspector;
        return this.parquetRow;
    }

    @Override
    public SerDeStats getSerDeStats() {
        assert (this.status != LAST_OPERATION.UNKNOWN);
        if (this.status == LAST_OPERATION.SERIALIZE) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.deserializedSize);
        }
        return this.stats;
    }

    static {
        for (int prec = 1; prec <= 38; ++prec) {
            ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1] = (int)Math.ceil((Math.log(Math.pow(10.0, prec) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
    }

    private static enum LAST_OPERATION {
        SERIALIZE,
        DESERIALIZE,
        UNKNOWN;

    }
}

