/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.org.codehaus.jackson.node;

import hive.parquet.org.codehaus.jackson.JsonGenerator;
import hive.parquet.org.codehaus.jackson.JsonProcessingException;
import hive.parquet.org.codehaus.jackson.JsonToken;
import hive.parquet.org.codehaus.jackson.map.SerializerProvider;
import hive.parquet.org.codehaus.jackson.node.ValueNode;
import java.io.IOException;

public final class BooleanNode
extends ValueNode {
    public static final BooleanNode TRUE = new BooleanNode();
    public static final BooleanNode FALSE = new BooleanNode();

    private BooleanNode() {
    }

    public static BooleanNode getTrue() {
        return TRUE;
    }

    public static BooleanNode getFalse() {
        return FALSE;
    }

    public static BooleanNode valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public JsonToken asToken() {
        return this == TRUE ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean getBooleanValue() {
        return this == TRUE;
    }

    public String asText() {
        return this == TRUE ? "true" : "false";
    }

    public boolean asBoolean() {
        return this == TRUE;
    }

    public boolean asBoolean(boolean defaultValue) {
        return this == TRUE;
    }

    public int asInt(int defaultValue) {
        return this == TRUE ? 1 : 0;
    }

    public long asLong(long defaultValue) {
        return this == TRUE ? 1L : 0L;
    }

    public double asDouble(double defaultValue) {
        return this == TRUE ? 1.0 : 0.0;
    }

    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeBoolean(this == TRUE);
    }

    public boolean equals(Object o) {
        return o == this;
    }
}

