/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.io;

import hive.parquet.Log;
import hive.parquet.column.ColumnReadStore;
import hive.parquet.io.ParquetDecodingException;
import hive.parquet.io.RecordReader;
import hive.parquet.io.RecordReaderImplementation;
import hive.parquet.io.api.Binary;
import hive.parquet.io.api.RecordConsumer;
import hive.parquet.io.api.RecordMaterializer;

public abstract class BaseRecordReader<T>
extends RecordReader<T> {
    private static final Log LOG = Log.getLog(BaseRecordReader.class);
    public RecordConsumer recordConsumer;
    public RecordMaterializer<T> recordMaterializer;
    public ColumnReadStore columnStore;
    RecordReaderImplementation.State[] caseLookup;
    private String endField;
    private int endIndex;

    @Override
    public T read() {
        this.readOneRecord();
        return this.recordMaterializer.getCurrentRecord();
    }

    protected abstract void readOneRecord();

    protected void currentLevel(int currentLevel) {
        if (Log.DEBUG) {
            LOG.debug("currentLevel: " + currentLevel);
        }
    }

    protected void log(String message) {
        if (Log.DEBUG) {
            LOG.debug("bc: " + message);
        }
    }

    protected final int getCaseId(int state, int currentLevel, int d, int nextR) {
        return this.caseLookup[state].getCase(currentLevel, d, nextR).getID();
    }

    protected final void startMessage() {
        this.endField = null;
        if (Log.DEBUG) {
            LOG.debug("startMessage()");
        }
        this.recordConsumer.startMessage();
    }

    protected final void startGroup(String field, int index) {
        this.startField(field, index);
        if (Log.DEBUG) {
            LOG.debug("startGroup()");
        }
        this.recordConsumer.startGroup();
    }

    private void startField(String field, int index) {
        if (Log.DEBUG) {
            LOG.debug("startField(" + field + "," + index + ")");
        }
        if (this.endField != null && index == this.endIndex) {
            this.endField = null;
        } else {
            if (this.endField != null) {
                this.recordConsumer.endField(this.endField, this.endIndex);
                this.endField = null;
            }
            this.recordConsumer.startField(field, index);
        }
    }

    protected final void addPrimitiveINT64(String field, int index, long value) {
        this.startField(field, index);
        if (Log.DEBUG) {
            LOG.debug("addLong(" + value + ")");
        }
        this.recordConsumer.addLong(value);
        this.endField(field, index);
    }

    private void endField(String field, int index) {
        if (Log.DEBUG) {
            LOG.debug("endField(" + field + "," + index + ")");
        }
        if (this.endField != null) {
            this.recordConsumer.endField(this.endField, this.endIndex);
        }
        this.endField = field;
        this.endIndex = index;
    }

    protected final void addPrimitiveBINARY(String field, int index, Binary value) {
        this.startField(field, index);
        if (Log.DEBUG) {
            LOG.debug("addBinary(" + value + ")");
        }
        this.recordConsumer.addBinary(value);
        this.endField(field, index);
    }

    protected final void addPrimitiveINT32(String field, int index, int value) {
        this.startField(field, index);
        if (Log.DEBUG) {
            LOG.debug("addInteger(" + value + ")");
        }
        this.recordConsumer.addInteger(value);
        this.endField(field, index);
    }

    protected final void endGroup(String field, int index) {
        if (this.endField != null) {
            this.recordConsumer.endField(this.endField, this.endIndex);
            this.endField = null;
        }
        if (Log.DEBUG) {
            LOG.debug("endGroup()");
        }
        this.recordConsumer.endGroup();
        this.endField(field, index);
    }

    protected final void endMessage() {
        if (this.endField != null) {
            this.recordConsumer.endField(this.endField, this.endIndex);
            this.endField = null;
        }
        if (Log.DEBUG) {
            LOG.debug("endMessage()");
        }
        this.recordConsumer.endMessage();
    }

    protected void error(String message) {
        throw new ParquetDecodingException(message);
    }
}

