/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.hadoop.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class ContextUtil {
    private static final boolean useV21;
    private static final Constructor<?> JOB_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> TASK_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> MAP_CONTEXT_CONSTRUCTOR;
    private static final Constructor<?> MAP_CONTEXT_IMPL_CONSTRUCTOR;
    private static final Constructor<?> GENERIC_COUNTER_CONSTRUCTOR;
    private static final Field READER_FIELD;
    private static final Field WRITER_FIELD;
    private static final Field OUTER_MAP_FIELD;
    private static final Field WRAPPED_CONTEXT_FIELD;
    private static final Method GET_CONFIGURATION_METHOD;
    private static final Method GET_COUNTER_METHOD;
    private static final Method INCREMENT_COUNTER_METHOD;

    public static JobContext newJobContext(Configuration conf, JobID jobId) {
        try {
            return (JobContext)JOB_CONTEXT_CONSTRUCTOR.newInstance(conf, jobId);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate JobContext", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate JobContext", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate JobContext", e);
        }
    }

    public static TaskAttemptContext newTaskAttemptContext(Configuration conf, TaskAttemptID taskAttemptId) {
        try {
            return (TaskAttemptContext)TASK_CONTEXT_CONSTRUCTOR.newInstance(conf, taskAttemptId);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate TaskAttemptContext", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate TaskAttemptContext", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate TaskAttemptContext", e);
        }
    }

    public static Counter newGenericCounter(String name, String displayName, long value) {
        try {
            return (Counter)GENERIC_COUNTER_CONSTRUCTOR.newInstance(name, displayName, value);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't instantiate Counter", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't instantiate Counter", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate Counter", e);
        }
    }

    public static Configuration getConfiguration(JobContext context) {
        try {
            return (Configuration)GET_CONFIGURATION_METHOD.invoke((Object)context, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't invoke method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't invoke method", e);
        }
    }

    public static Counter getCounter(TaskInputOutputContext context, String groupName, String counterName) {
        return (Counter)ContextUtil.invoke(GET_COUNTER_METHOD, context, groupName, counterName);
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
    }

    public static void incrementCounter(Counter counter, long increment) {
        ContextUtil.invoke(INCREMENT_COUNTER_METHOD, counter, increment);
    }

    static {
        Class<?> genericCounterCls;
        Class<?> innerMapContextCls;
        Class<?> mapCls;
        Class<?> mapContextCls;
        Class<?> taskIOContextCls;
        Class<?> taskContextCls;
        Class<?> jobContextCls;
        boolean v21 = true;
        String PACKAGE = "org.apache.hadoop.mapreduce";
        try {
            Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
        }
        catch (ClassNotFoundException cnfe) {
            v21 = false;
        }
        useV21 = v21;
        try {
            if (v21) {
                jobContextCls = Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
                taskContextCls = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
                taskIOContextCls = Class.forName("org.apache.hadoop.mapreduce.task.TaskInputOutputContextImpl");
                mapContextCls = Class.forName("org.apache.hadoop.mapreduce.task.MapContextImpl");
                mapCls = Class.forName("org.apache.hadoop.mapreduce.lib.map.WrappedMapper");
                innerMapContextCls = Class.forName("org.apache.hadoop.mapreduce.lib.map.WrappedMapper$Context");
                genericCounterCls = Class.forName("org.apache.hadoop.mapreduce.counters.GenericCounter");
            } else {
                jobContextCls = Class.forName("org.apache.hadoop.mapreduce.JobContext");
                taskContextCls = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptContext");
                taskIOContextCls = Class.forName("org.apache.hadoop.mapreduce.TaskInputOutputContext");
                mapContextCls = Class.forName("org.apache.hadoop.mapreduce.MapContext");
                mapCls = Class.forName("org.apache.hadoop.mapreduce.Mapper");
                innerMapContextCls = Class.forName("org.apache.hadoop.mapreduce.Mapper$Context");
                genericCounterCls = Class.forName("org.apache.hadoop.mapred.Counters$Counter");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class", e);
        }
        try {
            JOB_CONTEXT_CONSTRUCTOR = jobContextCls.getConstructor(Configuration.class, JobID.class);
            JOB_CONTEXT_CONSTRUCTOR.setAccessible(true);
            TASK_CONTEXT_CONSTRUCTOR = taskContextCls.getConstructor(Configuration.class, TaskAttemptID.class);
            TASK_CONTEXT_CONSTRUCTOR.setAccessible(true);
            GENERIC_COUNTER_CONSTRUCTOR = genericCounterCls.getDeclaredConstructor(String.class, String.class, Long.TYPE);
            GENERIC_COUNTER_CONSTRUCTOR.setAccessible(true);
            if (useV21) {
                Method get_counter_method;
                MAP_CONTEXT_CONSTRUCTOR = innerMapContextCls.getConstructor(mapCls, MapContext.class);
                MAP_CONTEXT_IMPL_CONSTRUCTOR = mapContextCls.getDeclaredConstructor(Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                MAP_CONTEXT_IMPL_CONSTRUCTOR.setAccessible(true);
                WRAPPED_CONTEXT_FIELD = innerMapContextCls.getDeclaredField("mapContext");
                WRAPPED_CONTEXT_FIELD.setAccessible(true);
                try {
                    get_counter_method = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptContext").getMethod("getCounter", String.class, String.class);
                }
                catch (Exception e) {
                    get_counter_method = Class.forName("org.apache.hadoop.mapreduce.TaskInputOutputContext").getMethod("getCounter", String.class, String.class);
                }
                GET_COUNTER_METHOD = get_counter_method;
            } else {
                MAP_CONTEXT_CONSTRUCTOR = innerMapContextCls.getConstructor(mapCls, Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                MAP_CONTEXT_IMPL_CONSTRUCTOR = null;
                WRAPPED_CONTEXT_FIELD = null;
                GET_COUNTER_METHOD = taskIOContextCls.getMethod("getCounter", String.class, String.class);
            }
            MAP_CONTEXT_CONSTRUCTOR.setAccessible(true);
            READER_FIELD = mapContextCls.getDeclaredField("reader");
            READER_FIELD.setAccessible(true);
            WRITER_FIELD = taskIOContextCls.getDeclaredField("output");
            WRITER_FIELD.setAccessible(true);
            OUTER_MAP_FIELD = innerMapContextCls.getDeclaredField("this$0");
            OUTER_MAP_FIELD.setAccessible(true);
            GET_CONFIGURATION_METHOD = Class.forName("org.apache.hadoop.mapreduce.JobContext").getMethod("getConfiguration", new Class[0]);
            INCREMENT_COUNTER_METHOD = Class.forName("org.apache.hadoop.mapreduce.Counter").getMethod("increment", Long.TYPE);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Can't run constructor ", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor ", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Can't find field ", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class", e);
        }
    }
}

