/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.hadoop;

import hive.parquet.Log;
import hive.parquet.Preconditions;
import hive.parquet.column.ColumnDescriptor;
import hive.parquet.column.page.PageReadStore;
import hive.parquet.filter.UnboundRecordFilter;
import hive.parquet.filter2.compat.FilterCompat;
import hive.parquet.hadoop.ParquetFileReader;
import hive.parquet.hadoop.api.InitContext;
import hive.parquet.hadoop.api.ReadSupport;
import hive.parquet.hadoop.metadata.BlockMetaData;
import hive.parquet.hadoop.util.counters.BenchmarkCounter;
import hive.parquet.io.ColumnIOFactory;
import hive.parquet.io.MessageColumnIO;
import hive.parquet.io.ParquetDecodingException;
import hive.parquet.io.RecordReader;
import hive.parquet.io.api.RecordMaterializer;
import hive.parquet.schema.GroupType;
import hive.parquet.schema.MessageType;
import hive.parquet.schema.Type;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

class InternalParquetRecordReader<T> {
    private static final Log LOG = Log.getLog(InternalParquetRecordReader.class);
    private final ColumnIOFactory columnIOFactory = new ColumnIOFactory();
    private final FilterCompat.Filter filter;
    private MessageType requestedSchema;
    private MessageType fileSchema;
    private int columnCount;
    private final ReadSupport<T> readSupport;
    private RecordMaterializer<T> recordConverter;
    private T currentValue;
    private long total;
    private long current = 0L;
    private int currentBlock = -1;
    private ParquetFileReader reader;
    private RecordReader<T> recordReader;
    private boolean strictTypeChecking;
    private long totalTimeSpentReadingBytes;
    private long totalTimeSpentProcessingRecords;
    private long startedAssemblingCurrentBlockAt;
    private long totalCountLoadedSoFar = 0L;
    private Path file;

    public InternalParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter) {
        this.readSupport = readSupport;
        this.filter = Preconditions.checkNotNull(filter, "filter");
    }

    public InternalParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public InternalParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter) {
        this(readSupport, FilterCompat.get(filter));
    }

    private void checkRead() throws IOException {
        if (this.current == this.totalCountLoadedSoFar) {
            if (this.current != 0L) {
                this.totalTimeSpentProcessingRecords += System.currentTimeMillis() - this.startedAssemblingCurrentBlockAt;
                if (Log.INFO) {
                    LOG.info("Assembled and processed " + this.totalCountLoadedSoFar + " records from " + this.columnCount + " columns in " + this.totalTimeSpentProcessingRecords + " ms: " + (float)this.totalCountLoadedSoFar / (float)this.totalTimeSpentProcessingRecords + " rec/ms, " + (float)this.totalCountLoadedSoFar * (float)this.columnCount / (float)this.totalTimeSpentProcessingRecords + " cell/ms");
                    long totalTime = this.totalTimeSpentProcessingRecords + this.totalTimeSpentReadingBytes;
                    if (totalTime != 0L) {
                        long percentReading = 100L * this.totalTimeSpentReadingBytes / totalTime;
                        long percentProcessing = 100L * this.totalTimeSpentProcessingRecords / totalTime;
                        LOG.info("time spent so far " + percentReading + "% reading (" + this.totalTimeSpentReadingBytes + " ms) and " + percentProcessing + "% processing (" + this.totalTimeSpentProcessingRecords + " ms)");
                    }
                }
            }
            LOG.info("at row " + this.current + ". reading next block");
            long t0 = System.currentTimeMillis();
            PageReadStore pages = this.reader.readNextRowGroup();
            if (pages == null) {
                throw new IOException("expecting more rows but reached last block. Read " + this.current + " out of " + this.total);
            }
            long timeSpentReading = System.currentTimeMillis() - t0;
            this.totalTimeSpentReadingBytes += timeSpentReading;
            BenchmarkCounter.incrementTime(timeSpentReading);
            if (Log.INFO) {
                LOG.info("block read in memory in " + timeSpentReading + " ms. row count = " + pages.getRowCount());
            }
            if (Log.DEBUG) {
                LOG.debug("initializing Record assembly with requested schema " + this.requestedSchema);
            }
            MessageColumnIO columnIO = this.columnIOFactory.getColumnIO(this.requestedSchema, this.fileSchema, this.strictTypeChecking);
            this.recordReader = columnIO.getRecordReader(pages, this.recordConverter, this.filter);
            this.startedAssemblingCurrentBlockAt = System.currentTimeMillis();
            this.totalCountLoadedSoFar += pages.getRowCount();
            ++this.currentBlock;
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.current / (float)this.total;
    }

    public void initialize(MessageType fileSchema, Map<String, String> fileMetadata, Path file, List<BlockMetaData> blocks, Configuration configuration) throws IOException {
        ReadSupport.ReadContext readContext = this.readSupport.init(new InitContext(configuration, InternalParquetRecordReader.toSetMultiMap(fileMetadata), fileSchema));
        this.requestedSchema = readContext.getRequestedSchema();
        this.fileSchema = fileSchema;
        this.file = file;
        this.columnCount = this.requestedSchema.getPaths().size();
        this.recordConverter = this.readSupport.prepareForRead(configuration, fileMetadata, fileSchema, readContext);
        this.strictTypeChecking = configuration.getBoolean("hive.parquet.strict.typing", true);
        List<ColumnDescriptor> columns = this.requestedSchema.getColumns();
        this.reader = new ParquetFileReader(configuration, file, blocks, columns);
        for (BlockMetaData block : blocks) {
            this.total += block.getRowCount();
        }
        LOG.info("RecordReader initialized will read a total of " + this.total + " records.");
    }

    private boolean contains(GroupType group, String[] path, int index) {
        if (index == path.length) {
            return false;
        }
        if (group.containsField(path[index])) {
            Type type = group.getType(path[index]);
            if (type.isPrimitive()) {
                return index + 1 == path.length;
            }
            return this.contains(type.asGroupType(), path, index + 1);
        }
        return false;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean recordFound = false;
        while (!recordFound) {
            if (this.current >= this.total) {
                return false;
            }
            try {
                this.checkRead();
                this.currentValue = this.recordReader.read();
                ++this.current;
                if (this.recordReader.shouldSkipCurrentRecord()) {
                    if (!Log.DEBUG) continue;
                    LOG.debug("skipping record");
                    continue;
                }
                if (this.currentValue == null) {
                    this.current = this.totalCountLoadedSoFar;
                    if (!Log.DEBUG) continue;
                    LOG.debug("filtered record reader reached end of block");
                    continue;
                }
                recordFound = true;
                if (!Log.DEBUG) continue;
                LOG.debug("read value: " + this.currentValue);
            }
            catch (RuntimeException e) {
                throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", this.current, this.currentBlock, this.file), e);
            }
        }
        return true;
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            HashSet<V> set = new HashSet<V>();
            set.add(entry.getValue());
            setMultiMap.put(entry.getKey(), Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }
}

