/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.hadoop;

import hive.parquet.bytes.BytesInput;
import hive.parquet.hadoop.BadConfigurationException;
import hive.parquet.hadoop.metadata.CompressionCodecName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.ReflectionUtils;

class CodecFactory {
    private final Map<CompressionCodecName, BytesCompressor> compressors = new HashMap<CompressionCodecName, BytesCompressor>();
    private final Map<CompressionCodecName, BytesDecompressor> decompressors = new HashMap<CompressionCodecName, BytesDecompressor>();
    private final Map<String, CompressionCodec> codecByName = new HashMap<String, CompressionCodec>();
    private final Configuration configuration;

    public CodecFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    private CompressionCodec getCodec(CompressionCodecName codecName) {
        String codecClassName = codecName.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        CompressionCodec codec = this.codecByName.get(codecClassName);
        if (codec != null) {
            return codec;
        }
        try {
            Class<?> codecClass = Class.forName(codecClassName);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.configuration);
            this.codecByName.put(codecClassName, codec);
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Class " + codecClassName + " was not found", e);
        }
    }

    public BytesCompressor getCompressor(CompressionCodecName codecName, int pageSize) {
        BytesCompressor comp = this.compressors.get((Object)codecName);
        if (comp == null) {
            CompressionCodec codec = this.getCodec(codecName);
            comp = new BytesCompressor(codecName, codec, pageSize);
            this.compressors.put(codecName, comp);
        }
        return comp;
    }

    public BytesDecompressor getDecompressor(CompressionCodecName codecName) {
        BytesDecompressor decomp = this.decompressors.get((Object)codecName);
        if (decomp == null) {
            CompressionCodec codec = this.getCodec(codecName);
            decomp = new BytesDecompressor(codec);
            this.decompressors.put(codecName, decomp);
        }
        return decomp;
    }

    public void release() {
        for (BytesCompressor compressor : this.compressors.values()) {
            compressor.release();
        }
        this.compressors.clear();
        for (BytesDecompressor decompressor : this.decompressors.values()) {
            decompressor.release();
        }
        this.decompressors.clear();
    }

    public static class BytesCompressor {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ByteArrayOutputStream compressedOutBuffer;
        private final CompressionCodecName codecName;

        public BytesCompressor(CompressionCodecName codecName, CompressionCodec codec, int pageSize) {
            this.codecName = codecName;
            this.codec = codec;
            if (codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
                this.compressedOutBuffer = new ByteArrayOutputStream(pageSize);
            } else {
                this.compressor = null;
                this.compressedOutBuffer = null;
            }
        }

        public BytesInput compress(BytesInput bytes) throws IOException {
            BytesInput compressedBytes;
            if (this.codec == null) {
                compressedBytes = bytes;
            } else {
                this.compressedOutBuffer.reset();
                if (this.compressor != null) {
                    this.compressor.reset();
                }
                CompressionOutputStream cos = this.codec.createOutputStream((OutputStream)this.compressedOutBuffer, this.compressor);
                bytes.writeAllTo((OutputStream)cos);
                cos.finish();
                cos.close();
                compressedBytes = BytesInput.from(this.compressedOutBuffer);
            }
            return compressedBytes;
        }

        private void release() {
            if (this.compressor != null) {
                CodecPool.returnCompressor((Compressor)this.compressor);
            }
        }

        public CompressionCodecName getCodecName() {
            return this.codecName;
        }
    }

    public class BytesDecompressor {
        private final CompressionCodec codec;
        private final Decompressor decompressor;

        public BytesDecompressor(CompressionCodec codec) {
            this.codec = codec;
            this.decompressor = codec != null ? CodecPool.getDecompressor((CompressionCodec)codec) : null;
        }

        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            BytesInput decompressed;
            if (this.codec != null) {
                this.decompressor.reset();
                CompressionInputStream is = this.codec.createInputStream((InputStream)new ByteArrayInputStream(bytes.toByteArray()), this.decompressor);
                decompressed = BytesInput.from((InputStream)is, uncompressedSize);
            } else {
                decompressed = bytes;
            }
            return decompressed;
        }

        private void release() {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }
}

