/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.plain;

import hive.parquet.bytes.BytesInput;
import hive.parquet.column.Encoding;
import hive.parquet.column.values.ValuesWriter;
import hive.parquet.column.values.bitpacking.ByteBitPackingValuesWriter;
import hive.parquet.column.values.bitpacking.Packer;

public class BooleanPlainValuesWriter
extends ValuesWriter {
    private ByteBitPackingValuesWriter bitPackingWriter = new ByteBitPackingValuesWriter(1, Packer.LITTLE_ENDIAN);

    @Override
    public final void writeBoolean(boolean v) {
        this.bitPackingWriter.writeInteger(v ? 1 : 0);
    }

    @Override
    public long getBufferedSize() {
        return this.bitPackingWriter.getBufferedSize();
    }

    @Override
    public BytesInput getBytes() {
        return this.bitPackingWriter.getBytes();
    }

    @Override
    public void reset() {
        this.bitPackingWriter.reset();
    }

    @Override
    public long getAllocatedSize() {
        return this.bitPackingWriter.getAllocatedSize();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.bitPackingWriter.memUsageString(prefix);
    }
}

