/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.fallback;

import hive.parquet.bytes.BytesInput;
import hive.parquet.column.Encoding;
import hive.parquet.column.page.DictionaryPage;
import hive.parquet.column.values.RequiresFallback;
import hive.parquet.column.values.ValuesWriter;
import hive.parquet.io.api.Binary;

public class FallbackValuesWriter<I extends ValuesWriter, F extends ValuesWriter>
extends ValuesWriter {
    public final I initialWriter;
    public final F fallBackWriter;
    private boolean fellBackAlready = false;
    private ValuesWriter currentWriter;
    private boolean initialUsedAndHadDictionary = false;
    private long rawDataByteSize = 0L;
    private boolean firstPage = true;

    public static <I extends ValuesWriter, F extends ValuesWriter> FallbackValuesWriter<I, F> of(I initialWriter, F fallBackWriter) {
        return new FallbackValuesWriter<I, F>(initialWriter, fallBackWriter);
    }

    public FallbackValuesWriter(I initialWriter, F fallBackWriter) {
        this.initialWriter = initialWriter;
        this.fallBackWriter = fallBackWriter;
        this.currentWriter = initialWriter;
    }

    @Override
    public long getBufferedSize() {
        return this.rawDataByteSize;
    }

    @Override
    public BytesInput getBytes() {
        if (!this.fellBackAlready && this.firstPage) {
            BytesInput bytes = ((ValuesWriter)this.initialWriter).getBytes();
            if (!((RequiresFallback)this.initialWriter).isCompressionSatisfying(this.rawDataByteSize, bytes.size())) {
                this.fallBack();
            } else {
                return bytes;
            }
        }
        return this.currentWriter.getBytes();
    }

    @Override
    public Encoding getEncoding() {
        Encoding encoding = this.currentWriter.getEncoding();
        if (!this.fellBackAlready && !this.initialUsedAndHadDictionary) {
            this.initialUsedAndHadDictionary = encoding.usesDictionary();
        }
        return encoding;
    }

    @Override
    public void reset() {
        this.rawDataByteSize = 0L;
        this.firstPage = false;
        this.currentWriter.reset();
    }

    @Override
    public DictionaryPage createDictionaryPage() {
        if (this.initialUsedAndHadDictionary) {
            return ((ValuesWriter)this.initialWriter).createDictionaryPage();
        }
        return this.currentWriter.createDictionaryPage();
    }

    @Override
    public void resetDictionary() {
        if (this.initialUsedAndHadDictionary) {
            ((ValuesWriter)this.initialWriter).resetDictionary();
        } else {
            this.currentWriter.resetDictionary();
        }
        this.currentWriter = this.initialWriter;
        this.fellBackAlready = false;
        this.initialUsedAndHadDictionary = false;
        this.firstPage = true;
    }

    @Override
    public long getAllocatedSize() {
        return this.currentWriter.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s FallbackValuesWriter{\n%s\n%s\n%s}\n", prefix, ((ValuesWriter)this.initialWriter).memUsageString(prefix + " initial:"), ((ValuesWriter)this.fallBackWriter).memUsageString(prefix + " fallback:"), prefix);
    }

    private void checkFallback() {
        if (!this.fellBackAlready && ((RequiresFallback)this.initialWriter).shouldFallBack()) {
            this.fallBack();
        }
    }

    private void fallBack() {
        this.fellBackAlready = true;
        ((RequiresFallback)this.initialWriter).fallBackAllValuesTo((ValuesWriter)this.fallBackWriter);
        this.currentWriter = this.fallBackWriter;
    }

    @Override
    public void writeByte(int value) {
        ++this.rawDataByteSize;
        this.currentWriter.writeByte(value);
        this.checkFallback();
    }

    @Override
    public void writeBytes(Binary v) {
        this.rawDataByteSize += (long)(v.length() + 4);
        this.currentWriter.writeBytes(v);
        this.checkFallback();
    }

    @Override
    public void writeInteger(int v) {
        this.rawDataByteSize += 4L;
        this.currentWriter.writeInteger(v);
        this.checkFallback();
    }

    @Override
    public void writeLong(long v) {
        this.rawDataByteSize += 8L;
        this.currentWriter.writeLong(v);
        this.checkFallback();
    }

    @Override
    public void writeFloat(float v) {
        this.rawDataByteSize += 4L;
        this.currentWriter.writeFloat(v);
        this.checkFallback();
    }

    @Override
    public void writeDouble(double v) {
        this.rawDataByteSize += 8L;
        this.currentWriter.writeDouble(v);
        this.checkFallback();
    }
}

