/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.deltalengthbytearray;

import hive.parquet.Log;
import hive.parquet.column.values.ValuesReader;
import hive.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import hive.parquet.io.api.Binary;
import java.io.IOException;

public class DeltaLengthByteArrayValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(DeltaLengthByteArrayValuesReader.class);
    private ValuesReader lengthReader = new DeltaBinaryPackingValuesReader();
    private byte[] in;
    private int offset;

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.lengthReader.initFromPage(valueCount, in, offset);
        offset = this.lengthReader.getNextOffset();
        this.in = in;
        this.offset = offset;
    }

    @Override
    public Binary readBytes() {
        int length = this.lengthReader.readInteger();
        int start = this.offset;
        this.offset = start + length;
        return Binary.fromByteArray(this.in, start, length);
    }

    @Override
    public void skip() {
        int length = this.lengthReader.readInteger();
        this.offset += length;
    }
}

