/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.bitpacking;

import hive.parquet.bytes.BytesInput;
import hive.parquet.bytes.BytesUtils;
import hive.parquet.bytes.CapacityByteArrayOutputStream;
import hive.parquet.column.Encoding;
import hive.parquet.column.values.ValuesWriter;
import hive.parquet.column.values.bitpacking.BitPacking;
import hive.parquet.io.ParquetEncodingException;
import java.io.IOException;

public class BitPackingValuesWriter
extends ValuesWriter {
    private CapacityByteArrayOutputStream out;
    private BitPacking.BitPackingWriter bitPackingWriter;
    private int bitsPerValue;

    public BitPackingValuesWriter(int bound, int initialCapacity, int pageSize) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
        this.out = new CapacityByteArrayOutputStream(initialCapacity, pageSize);
        this.init();
    }

    private void init() {
        this.bitPackingWriter = BitPacking.getBitPackingWriter(this.bitsPerValue, this.out);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.bitPackingWriter.write(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.out.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.bitPackingWriter.finish();
            return BytesInput.from(this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public void reset() {
        this.out.reset();
        this.init();
    }

    @Override
    public long getAllocatedSize() {
        return this.out.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.out.memUsageString(prefix);
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.BIT_PACKED;
    }
}

