/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.commons.codec.binary;

import hive.org.apache.commons.codec.binary.Base64;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private final boolean doEncode;
    private final Base64 base64;
    private final byte[] singleByte = new byte[1];

    public Base64OutputStream(OutputStream out) {
        this(out, true);
    }

    public Base64OutputStream(OutputStream out, boolean doEncode) {
        super(out);
        this.doEncode = doEncode;
        this.base64 = new Base64();
    }

    public Base64OutputStream(OutputStream out, boolean doEncode, int lineLength, byte[] lineSeparator) {
        super(out);
        this.doEncode = doEncode;
        this.base64 = new Base64(lineLength, lineSeparator);
    }

    public void write(int i) throws IOException {
        this.singleByte[0] = (byte)i;
        this.write(this.singleByte, 0, 1);
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset > b.length || offset + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > 0) {
            if (this.doEncode) {
                this.base64.encode(b, offset, len);
            } else {
                this.base64.decode(b, offset, len);
            }
            this.flush(false);
        }
    }

    private void flush(boolean propogate) throws IOException {
        byte[] buf;
        int c;
        int avail = this.base64.avail();
        if (avail > 0 && (c = this.base64.readResults(buf = new byte[avail], 0, avail)) > 0) {
            this.out.write(buf, 0, c);
        }
        if (propogate) {
            this.out.flush();
        }
    }

    public void flush() throws IOException {
        this.flush(true);
    }

    public void close() throws IOException {
        if (this.doEncode) {
            this.base64.encode(this.singleByte, 0, -1);
        } else {
            this.base64.decode(this.singleByte, 0, -1);
        }
        this.flush();
        this.out.close();
    }
}

