/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.util;

import hive.org.apache.calcite.avatica.util.DateTimeUtils;
import hive.org.apache.calcite.util.ZonelessDatetime;
import java.sql.Timestamp;
import java.text.DateFormat;

public class ZonelessTimestamp
extends ZonelessDatetime {
    private static final long serialVersionUID = -6829714640541648394L;
    protected final int precision;
    protected transient Timestamp tempTimestamp;

    public ZonelessTimestamp() {
        this.precision = 0;
    }

    public ZonelessTimestamp(int precision) {
        this.precision = precision;
    }

    @Override
    public Object toJdbcObject() {
        return new Timestamp(this.getJdbcTimestamp(DateTimeUtils.DEFAULT_ZONE));
    }

    public String toString() {
        Timestamp ts = this.getTempTimestamp(this.getJdbcTimestamp(DateTimeUtils.DEFAULT_ZONE));
        return ts.toString().substring(0, 19);
    }

    public String toString(String format) {
        DateFormat formatter = this.getFormatter(format);
        Timestamp ts = this.getTempTimestamp(this.getTime());
        return formatter.format(ts);
    }

    public static ZonelessTimestamp parse(String s) {
        return ZonelessTimestamp.parse(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static ZonelessTimestamp parse(String s, String format) {
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral(s, format, DateTimeUtils.GMT_ZONE);
        if (pt == null) {
            return null;
        }
        ZonelessTimestamp zt = new ZonelessTimestamp(pt.getPrecision());
        zt.setZonelessTime(pt.getCalendar().getTime().getTime());
        return zt;
    }

    protected Timestamp getTempTimestamp(long value) {
        if (this.tempTimestamp == null) {
            this.tempTimestamp = new Timestamp(value);
        } else {
            this.tempTimestamp.setTime(value);
        }
        return this.tempTimestamp;
    }
}

