/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlQualified {
    private final SqlValidatorScope scope;
    public final int prefixLength;
    public final SqlValidatorNamespace namespace;
    public final SqlIdentifier identifier;

    private SqlQualified(SqlValidatorScope scope, int prefixLength, SqlValidatorNamespace namespace, SqlIdentifier identifier) {
        this.scope = scope;
        this.prefixLength = prefixLength;
        this.namespace = namespace;
        this.identifier = identifier;
    }

    public static SqlQualified create(SqlValidatorScope scope, int prefixLength, SqlValidatorNamespace namespace, SqlIdentifier identifier) {
        return new SqlQualified(scope, prefixLength, namespace, identifier);
    }

    public List<String> translatedNames() {
        if (this.scope == null) {
            return this.identifier.names;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        SqlValidatorNamespace namespace = this.scope.resolve(Util.skipLast(this.identifier.names), null, null);
        builder.add(this.identifier.names.get(0));
        for (String name : Util.skip(this.identifier.names)) {
            if (namespace != null) {
                name = namespace.translate(name);
                namespace = null;
            }
            builder.add(name);
        }
        return builder.build();
    }

    public final List<String> prefix() {
        return this.identifier.names.subList(0, this.prefixLength);
    }

    public final List<String> suffix() {
        return Util.skip(this.identifier.names, this.prefixLength);
    }

    public final List<String> suffixTranslated() {
        return Util.skip(this.translatedNames(), this.prefixLength);
    }
}

