/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.SqlSelect;
import hive.org.apache.calcite.sql.validate.DelegatingScope;
import hive.org.apache.calcite.sql.validate.SqlMoniker;
import hive.org.apache.calcite.sql.validate.SqlQualified;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.util.List;

public class OrderByScope
extends DelegatingScope {
    private final SqlNodeList orderList;
    private final SqlSelect select;

    OrderByScope(SqlValidatorScope parent, SqlNodeList orderList, SqlSelect select) {
        super(parent);
        this.orderList = orderList;
        this.select = select;
    }

    @Override
    public SqlNode getNode() {
        return this.orderList;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        SqlValidatorNamespace ns = this.validator.getNamespace(this.select);
        this.addColumnNames(ns, result);
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        if (identifier.isSimple() && this.validator.getConformance().isSortByAlias()) {
            String name = (String)identifier.names.get(0);
            SqlValidatorNamespace selectNs = this.validator.getNamespace(this.select);
            RelDataType rowType = selectNs.getRowType();
            RelDataTypeField field = this.validator.catalogReader.field(rowType, name);
            if (field != null && !field.getName().startsWith("*")) {
                return SqlQualified.create(this, 1, selectNs, identifier);
            }
        }
        return super.fullyQualify(identifier);
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        SqlValidatorNamespace selectNs = this.validator.getNamespace(this.select);
        RelDataType rowType = selectNs.getRowType();
        RelDataTypeField field = this.validator.catalogReader.field(rowType, name);
        if (field != null) {
            return field.getType();
        }
        SqlValidatorScope selectScope = this.validator.getSelectScope(this.select);
        return selectScope.resolveColumn(name, ctx);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        SqlNode expanded = this.validator.expandOrderExpr(this.select, expr);
        this.parent.validateExpr(expanded);
    }
}

