/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableMap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Maps;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.linq4j.Linq4j;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.SqlSelect;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.validate.AggChecker;
import hive.org.apache.calcite.sql.validate.AggregatingScope;
import hive.org.apache.calcite.sql.validate.DelegatingScope;
import hive.org.apache.calcite.sql.validate.SelectScope;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.sql.validate.SqlValidatorUtil;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;
    private final List<SqlNode> temporaryGroupExprList = Lists.newArrayList();
    public final ImmutableList<SqlNode> groupExprList;
    public final ImmutableBitSet groupSet;
    public final ImmutableList<ImmutableBitSet> groupSets;
    public final boolean indicator;
    public final Map<Integer, Integer> groupExprProjection;

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select, boolean distinct) {
        super(selectScope);
        this.select = select;
        this.distinct = distinct;
        HashMap<Integer, Integer> groupExprProjection = Maps.newHashMap();
        ImmutableList.Builder<ImmutableList<ImmutableBitSet>> builder = ImmutableList.builder();
        if (select.getGroup() != null) {
            SqlNodeList groupList = SqlValidatorUtil.ExpansionAndDeepCopier.copy(this.parent, select.getGroup());
            for (SqlNode groupExpr : groupList) {
                SqlValidatorUtil.analyzeGroupItem(this, this.temporaryGroupExprList, groupExprProjection, builder, groupExpr);
            }
        }
        this.groupExprList = ImmutableList.copyOf(this.temporaryGroupExprList);
        this.groupExprProjection = ImmutableMap.copyOf(groupExprProjection);
        TreeSet<ImmutableBitSet> flatGroupSets = Sets.newTreeSet(ImmutableBitSet.COMPARATOR);
        for (List groupSet : Linq4j.product((Iterable)builder.build())) {
            flatGroupSets.add(ImmutableBitSet.union(groupSet));
        }
        if (flatGroupSets.isEmpty()) {
            flatGroupSets.add(ImmutableBitSet.of());
        }
        this.groupSet = ImmutableBitSet.range(this.groupExprList.size());
        this.groupSets = ImmutableList.copyOf(flatGroupSets);
        this.indicator = !this.groupSets.equals(ImmutableList.of(this.groupSet));
    }

    private ImmutableList<SqlNode> getGroupExprs() {
        if (this.distinct) {
            assert (this.select.isDistinct());
            ImmutableList.Builder groupExprs = ImmutableList.builder();
            SelectScope selectScope = (SelectScope)this.parent;
            for (SqlNode selectItem : selectScope.getExpandedSelectList()) {
                groupExprs.add(SqlUtil.stripAs(selectItem));
            }
            return groupExprs.build();
        }
        if (this.select.getGroup() != null) {
            if (this.groupExprList != null) {
                return this.groupExprList;
            }
            return ImmutableList.copyOf(this.temporaryGroupExprList);
        }
        return ImmutableList.of();
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    public boolean isNullable(int i) {
        return i < this.groupExprList.size() && !AggregatingSelectScope.allContain(this.groupSets, i);
    }

    private static boolean allContain(List<ImmutableBitSet> bitSets, int bit) {
        for (ImmutableBitSet bitSet : bitSets) {
            if (bitSet.get(bit)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        for (Ord groupExpr : Ord.zip(this.groupExprList)) {
            if (!((SqlNode)groupExpr.e).equalsDeep(node, false) || !this.isNullable(groupExpr.i)) continue;
            return this.validator.getTypeFactory().createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        ImmutableList<SqlNode> groupExprs = this.getGroupExprs();
        AggChecker aggChecker = new AggChecker(this.validator, this, groupExprs, this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public boolean isGroupingExpr(SqlNode operand) {
        return this.lookupGroupingExpr(operand) >= 0;
    }

    public int lookupGroupingExpr(SqlNode operand) {
        for (Ord groupExpr : Ord.zip(this.groupExprList)) {
            if (!operand.equalsDeep((SqlNode)groupExpr.e, false)) continue;
            return groupExpr.i;
        }
        return -1;
    }
}

