/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.sql.type.SqlTypeTransform;

public class SqlTypeTransformCascade
implements SqlReturnTypeInference {
    private final SqlReturnTypeInference rule;
    private final ImmutableList<SqlTypeTransform> transforms;

    public SqlTypeTransformCascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        assert (rule != null);
        assert (transforms.length > 0);
        this.rule = rule;
        this.transforms = ImmutableList.copyOf(transforms);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = this.rule.inferReturnType(opBinding);
        if (ret == null) {
            return null;
        }
        for (SqlTypeTransform transform : this.transforms) {
            ret = transform.transformType(opBinding, ret);
        }
        return ret;
    }
}

