/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperandCountRange;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.type.SqlOperandCountRanges;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.util.Static;
import hive.org.apache.calcite.util.Util;
import java.util.Collections;
import java.util.List;

public class SameOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final int nOperands;

    public SameOperandTypeChecker(int nOperands) {
        this.nOperands = nOperands;
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public boolean isOptional(int i) {
        return false;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.checkOperandTypesImpl(callBinding, throwOnFailure, callBinding);
    }

    protected List<Integer> getOperandList(int operandCount) {
        return this.nOperands == -1 ? Util.range(0, operandCount) : Util.range(0, this.nOperands);
    }

    private boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, SqlCallBinding callBinding) {
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        assert (!throwOnFailure || callBinding != null);
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            if (operatorBinding.isOperandNull(i, false)) {
                if (throwOnFailure) {
                    throw callBinding.getValidator().newValidationError(callBinding.operand(i), Static.RESOURCE.nullIllegal());
                }
                return false;
            }
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 0 && !SqlTypeUtil.isComparable(types[i], types[prev])) {
                if (!throwOnFailure) {
                    return false;
                }
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    public boolean checkOperandTypes(SqlOperatorBinding operatorBinding) {
        return this.checkOperandTypesImpl(operatorBinding, false, null);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        if (this.nOperands == -1) {
            return SqlOperandCountRanges.any();
        }
        return SqlOperandCountRanges.of(this.nOperands);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, this.nOperands == -1 ? ImmutableList.of("EQUIVALENT_TYPE", "EQUIVALENT_TYPE", "...") : Collections.nCopies(this.nOperands, "EQUIVALENT_TYPE"));
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
        throw new UnsupportedOperationException();
    }
}

