/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.type;

import hive.com.google.common.base.Predicate;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperandCountRange;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.type.SqlOperandCountRanges;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlTypeFamily;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.util.Static;
import java.util.List;

public class FamilyOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    protected final ImmutableList<SqlTypeFamily> families;
    protected final Predicate<Integer> optional;

    FamilyOperandTypeChecker(List<SqlTypeFamily> families, Predicate<Integer> optional) {
        this.families = ImmutableList.copyOf(families);
        this.optional = optional;
    }

    @Override
    public boolean isOptional(int i) {
        return this.optional.apply(i);
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        SqlTypeFamily family = (SqlTypeFamily)this.families.get(iFormalOperand);
        if (family == SqlTypeFamily.ANY) {
            return true;
        }
        if (SqlUtil.isNullLiteral(node, false)) {
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
        SqlTypeName typeName = type.getSqlTypeName();
        if (typeName.getFamily() == SqlTypeFamily.ANY) {
            return true;
        }
        if (!family.getTypeNames().contains((Object)typeName)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (this.families.size() != callBinding.getOperandCount()) {
            return false;
        }
        for (Ord op : Ord.zip(callBinding.operands())) {
            if (this.checkSingleOperandType(callBinding, (SqlNode)op.e, op.i, throwOnFailure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        int max;
        int min;
        for (min = max = this.families.size(); min > 0 && this.optional.apply(min - 1); --min) {
        }
        return SqlOperandCountRanges.between(min, max);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, this.families);
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }
}

