/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.type.SameOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlTypeFamily;
import hive.org.apache.calcite.sql.type.SqlTypeTransforms;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import java.util.Arrays;
import java.util.List;

public class SqlTrimFunction
extends SqlFunction {
    public SqlTrimFunction() {
        super("TRIM", SqlKind.TRIM, ReturnTypes.cascade(ReturnTypes.ARG2, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.and(OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.STRING), new SameOperandTypeChecker(3){

            @Override
            protected List<Integer> getOperandList(int operandCount) {
                return ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2));
            }
        }), SqlFunctionCategory.STRING);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        assert (call.operand(0) instanceof SqlLiteral) : call.operand(0);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 3: {
                return "{0}([BOTH|LEADING|TRAILING} {1} FROM {2})";
            }
        }
        throw new AssertionError();
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        switch (operands.length) {
            case 1: {
                operands = new SqlNode[]{Flag.BOTH.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", pos), operands[0]};
                break;
            }
            case 3: {
                assert (operands[0] instanceof SqlLiteral && ((SqlLiteral)operands[0]).getValue() instanceof Flag);
                if (operands[1] != null) break;
                operands[1] = SqlLiteral.createCharString(" ", pos);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid operand count " + Arrays.toString(operands));
            }
        }
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
            return false;
        }
        return SqlTypeUtil.isCharTypeComparable(callBinding, ImmutableList.of(callBinding.operand(1), callBinding.operand(2)), throwOnFailure);
    }

    public static enum Flag implements SqlLiteral.SqlSymbol
    {
        BOTH(1, 1),
        LEADING(1, 0),
        TRAILING(0, 1);

        private final int left;
        private final int right;

        private Flag(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

