/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlSplittableAggFunction;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlMinMaxAggFunction
extends SqlAggFunction {
    public static final int MINMAX_INVALID = -1;
    public static final int MINMAX_PRIMITIVE = 0;
    public static final int MINMAX_COMPARABLE = 1;
    public static final int MINMAX_COMPARATOR = 2;
    public final List<RelDataType> argTypes;
    private final boolean isMin;
    private final int kind;

    public SqlMinMaxAggFunction(List<RelDataType> argTypes, boolean isMin, int kind) {
        super(isMin ? "MIN" : "MAX", null, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, null, OperandTypes.COMPARABLE_ORDERED, SqlFunctionCategory.SYSTEM, false, false);
        this.argTypes = argTypes;
        this.isMin = isMin;
        this.kind = kind;
    }

    public boolean isMin() {
        return this.isMin;
    }

    public int getMinMaxKind() {
        return this.kind;
    }

    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        switch (this.kind) {
            case 0: 
            case 1: {
                return this.argTypes;
            }
            case 2: {
                return this.argTypes.subList(1, 2);
            }
        }
        throw Util.newInternal("bad kind: " + this.kind);
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        switch (this.kind) {
            case 0: 
            case 1: {
                return this.argTypes.get(0);
            }
            case 2: {
                return this.argTypes.get(1);
            }
        }
        throw Util.newInternal("bad kind: " + this.kind);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz == SqlSplittableAggFunction.class) {
            return clazz.cast(SqlSplittableAggFunction.SelfSplitter.INSTANCE);
        }
        return super.unwrap(clazz);
    }
}

