/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.fun;

import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlCallBinding;
import hive.org.apache.calcite.sql.SqlCharStringLiteral;
import hive.org.apache.calcite.sql.SqlCollation;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.SqlSpecialOperator;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.InferTypes;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.sql.type.SqlTypeUtil;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.util.BitString;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.Static;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlLiteralChainOperator
extends SqlSpecialOperator {
    SqlLiteralChainOperator() {
        super("$LiteralChain", SqlKind.LITERAL_CHAIN, 80, true, ReturnTypes.ARG0, InferTypes.FIRST_KNOWN, OperandTypes.VARIADIC);
    }

    private boolean argTypesValid(SqlCallBinding callBinding) {
        if (callBinding.getOperandCount() < 2) {
            return true;
        }
        RelDataType firstType = null;
        for (Ord operand : Ord.zip(callBinding.operands())) {
            RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)operand.e);
            if (operand.i == 0) {
                firstType = type;
                continue;
            }
            if (SqlTypeUtil.sameNamedType(firstType, type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (!this.argTypesValid(callBinding)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = opBinding.getOperandType(0);
        SqlTypeName typeName = ret.getSqlTypeName();
        assert (typeName.allowsPrecNoScale()) : "LiteralChain has impossible operand type " + (Object)((Object)typeName);
        int size = 0;
        for (RelDataType type : opBinding.collectOperandTypes()) {
            size += type.getPrecision();
            assert (type.getSqlTypeName().equals((Object)typeName));
        }
        return opBinding.getTypeFactory().createSqlType(typeName, size);
    }

    @Override
    public String getAllowedSignatures(String opName) {
        return opName + "(...)";
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operandList = call.getOperandList();
        for (int i = 1; i < operandList.size(); ++i) {
            SqlParserPos prevPos = operandList.get(i - 1).getParserPosition();
            SqlNode operand = operandList.get(i);
            SqlParserPos pos = operand.getParserPosition();
            if (pos.getLineNum() > prevPos.getLineNum()) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.stringFragsOnSameLine());
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        SqlCollation collation = null;
        for (Ord operand : Ord.zip(call.getOperandList())) {
            SqlLiteral rand = (SqlLiteral)operand.e;
            if (operand.i > 0) {
                writer.newlineAndIndent();
            }
            if (rand instanceof SqlCharStringLiteral) {
                NlsString nls = ((SqlCharStringLiteral)rand).getNlsString();
                if (operand.i == 0) {
                    collation = nls.getCollation();
                    writer.literal(nls.asSql(true, false));
                    continue;
                }
                writer.literal(nls.asSql(false, false));
                continue;
            }
            if (operand.i == 0) {
                rand.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            if (rand.getTypeName() == SqlTypeName.BINARY) {
                BitString bs = (BitString)rand.getValue();
                writer.literal("'" + bs.toHexString() + "'");
                continue;
            }
            writer.literal("'" + rand.toValue() + "'");
        }
        if (collation != null) {
            collation.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    public static SqlLiteral concatenateOperands(SqlCall call) {
        List<SqlNode> operandList = call.getOperandList();
        assert (operandList.size() > 0);
        assert (operandList.get(0) instanceof SqlLiteral) : operandList.get(0).getClass();
        return SqlUtil.concatenateLiterals(Util.cast(operandList, SqlLiteral.class));
    }
}

