/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.advise;

import hive.com.google.common.collect.Iterables;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.enumerable.CallImplementor;
import hive.org.apache.calcite.adapter.enumerable.NotNullImplementor;
import hive.org.apache.calcite.adapter.enumerable.NullPolicy;
import hive.org.apache.calcite.adapter.enumerable.RexImpTable;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.Linq4j;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.Types;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.schema.FunctionParameter;
import hive.org.apache.calcite.schema.ImplementableFunction;
import hive.org.apache.calcite.schema.TableFunction;
import hive.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import hive.org.apache.calcite.sql.advise.SqlAdvisor;
import hive.org.apache.calcite.sql.advise.SqlAdvisorHint;
import hive.org.apache.calcite.sql.validate.SqlMoniker;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlAdvisorGetHintsFunction
implements TableFunction,
ImplementableFunction {
    private static final Expression ADVISOR = Expressions.convert_((Expression)Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET.method, (Expression[])new Expression[]{Expressions.constant((Object)DataContext.Variable.SQL_ADVISOR.camelName)}), SqlAdvisor.class);
    private static final Method GET_COMPLETION_HINTS = Types.lookupMethod(SqlAdvisorGetHintsFunction.class, (String)"getCompletionHints", (Class[])new Class[]{SqlAdvisor.class, String.class, Integer.TYPE});
    private static final CallImplementor IMPLEMENTOR = RexImpTable.createImplementor(new NotNullImplementor(){

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> operands) {
            return Expressions.call((Method)GET_COMPLETION_HINTS, Iterables.concat(Collections.singleton(ADVISOR), operands));
        }
    }, NullPolicy.ANY, false);
    private static final List<FunctionParameter> PARAMETERS = ReflectiveFunctionBase.builder().add(String.class, "sql").add(Integer.TYPE, "pos").build();

    @Override
    public CallImplementor getImplementor() {
        return IMPLEMENTOR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return typeFactory.createJavaType(SqlAdvisorHint.class);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        return SqlAdvisorHint.class;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    public static Enumerable<SqlAdvisorHint> getCompletionHints(SqlAdvisor advisor, String sql, int pos) {
        String[] replaced = new String[]{null};
        List<SqlMoniker> hints = advisor.getCompletionHints(sql, pos, replaced);
        ArrayList<SqlAdvisorHint> res = new ArrayList<SqlAdvisorHint>(hints.size() + 1);
        res.add(new SqlAdvisorHint(replaced[0], null, "MATCH"));
        for (SqlMoniker hint : hints) {
            res.add(new SqlAdvisorHint(hint));
        }
        return Linq4j.asEnumerable(res).asQueryable();
    }
}

