/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql;

import hive.org.apache.calcite.sql.JoinConditionType;
import hive.org.apache.calcite.sql.JoinType;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlLiteral;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlSyntax;
import hive.org.apache.calcite.sql.SqlWriter;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.util.ImmutableNullableList;
import hive.org.apache.calcite.util.Util;
import java.util.List;

public class SqlJoin
extends SqlCall {
    public static final SqlJoinOperator OPERATOR = new SqlJoinOperator();
    SqlNode left;
    SqlLiteral natural;
    SqlLiteral joinType;
    SqlNode right;
    SqlLiteral conditionType;
    SqlNode condition;

    public SqlJoin(SqlParserPos pos, SqlNode left, SqlLiteral natural, SqlLiteral joinType, SqlNode right, SqlLiteral conditionType, SqlNode condition) {
        super(pos);
        this.left = left;
        this.natural = natural;
        this.joinType = joinType;
        this.right = right;
        this.conditionType = conditionType;
        this.condition = condition;
        assert (natural.getTypeName() == SqlTypeName.BOOLEAN);
        assert (conditionType != null);
        assert (conditionType.symbolValue() instanceof JoinConditionType);
        assert (joinType != null);
        assert (joinType.symbolValue() instanceof JoinType);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.JOIN;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.left, this.natural, this.joinType, this.right, this.conditionType, this.condition);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.left = operand;
                break;
            }
            case 1: {
                this.natural = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.joinType = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.right = operand;
                break;
            }
            case 4: {
                this.conditionType = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.condition = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public final SqlNode getCondition() {
        return this.condition;
    }

    public final JoinConditionType getConditionType() {
        return (JoinConditionType)this.conditionType.symbolValue();
    }

    public SqlLiteral getConditionTypeNode() {
        return this.conditionType;
    }

    public final JoinType getJoinType() {
        return (JoinType)this.joinType.symbolValue();
    }

    public SqlLiteral getJoinTypeNode() {
        return this.joinType;
    }

    public final SqlNode getLeft() {
        return this.left;
    }

    public void setLeft(SqlNode left) {
        this.left = left;
    }

    public final boolean isNatural() {
        return this.natural.booleanValue();
    }

    public final SqlLiteral isNaturalNode() {
        return this.natural;
    }

    public final SqlNode getRight() {
        return this.right;
    }

    public void setRight(SqlNode right) {
        this.right = right;
    }

    public static class SqlJoinOperator
    extends SqlOperator {
        private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("USING");

        private SqlJoinOperator() {
            super("JOIN", SqlKind.JOIN, 16, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            return new SqlJoin(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], operands[3], (SqlLiteral)operands[4], operands[5]);
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlJoin join = (SqlJoin)call;
            join.left.unparse(writer, leftPrec, this.getLeftPrec());
            String natural = "";
            if (join.isNatural()) {
                natural = "NATURAL ";
            }
            switch (join.getJoinType()) {
                case COMMA: {
                    writer.sep(",", true);
                    break;
                }
                case CROSS: {
                    writer.sep(natural + "CROSS JOIN");
                    break;
                }
                case FULL: {
                    writer.sep(natural + "FULL JOIN");
                    break;
                }
                case INNER: {
                    writer.sep(natural + "INNER JOIN");
                    break;
                }
                case LEFT: {
                    writer.sep(natural + "LEFT JOIN");
                    break;
                }
                case RIGHT: {
                    writer.sep(natural + "RIGHT JOIN");
                    break;
                }
                default: {
                    throw Util.unexpected(join.getJoinType());
                }
            }
            join.right.unparse(writer, this.getRightPrec(), rightPrec);
            if (join.condition != null) {
                switch (join.getConditionType()) {
                    case USING: {
                        writer.keyword("USING");
                        assert (join.condition instanceof SqlNodeList);
                        SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "(", ")");
                        join.condition.unparse(writer, 0, 0);
                        writer.endList(frame);
                        break;
                    }
                    case ON: {
                        writer.keyword("ON");
                        join.condition.unparse(writer, leftPrec, rightPrec);
                        break;
                    }
                    default: {
                        throw Util.unexpected(join.getConditionType());
                    }
                }
            }
        }
    }
}

