/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexVariable;
import java.util.AbstractList;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class RexSlot
extends RexVariable {
    protected final int index;

    protected RexSlot(String name, int index, RelDataType type) {
        super(name, type);
        assert (index >= 0);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    protected static class SelfPopulatingList
    extends CopyOnWriteArrayList<String> {
        private final String prefix;

        SelfPopulatingList(String prefix, int initialSize) {
            super(SelfPopulatingList.fromTo(prefix, 0, initialSize));
            this.prefix = prefix;
        }

        private static AbstractList<String> fromTo(final String prefix, final int start, final int end) {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return prefix + (index + start);
                }

                @Override
                public int size() {
                    return end - start;
                }
            };
        }

        @Override
        public String get(int index) {
            while (true) {
                try {
                    return (String)super.get(index);
                }
                catch (IndexOutOfBoundsException e) {
                    if (index < 0) {
                        throw new IllegalArgumentException();
                    }
                    this.addAll(SelfPopulatingList.fromTo(this.prefix, this.size(), Math.max(index + 1, this.size() * 2)));
                    continue;
                }
                break;
            }
        }
    }
}

