/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Iterables;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexCorrelVariable;
import hive.org.apache.calcite.rex.RexDynamicParam;
import hive.org.apache.calcite.rex.RexFieldAccess;
import hive.org.apache.calcite.rex.RexFieldCollation;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexLocalRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexOver;
import hive.org.apache.calcite.rex.RexRangeRef;
import hive.org.apache.calcite.rex.RexVisitor;
import hive.org.apache.calcite.rex.RexWindow;
import hive.org.apache.calcite.rex.RexWindowBound;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class RexShuttle
implements RexVisitor<RexNode> {
    @Override
    public RexNode visitOver(RexOver over) {
        boolean[] update = new boolean[]{false};
        List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)over.operands, update);
        RexWindow window = this.visitWindow(over.getWindow());
        if (update[0] || window != over.getWindow()) {
            return new RexOver(over.getType(), over.getAggOperator(), clonedOperands, window);
        }
        return over;
    }

    public RexWindow visitWindow(RexWindow window) {
        boolean[] update = new boolean[]{false};
        List<RexFieldCollation> clonedOrderKeys = this.visitFieldCollations(window.orderKeys, update);
        List<RexNode> clonedPartitionKeys = this.visitList(window.partitionKeys, update);
        RexWindowBound lowerBound = window.getLowerBound().accept(this);
        RexWindowBound upperBound = window.getUpperBound().accept(this);
        if (update[0] || lowerBound != window.getLowerBound() && lowerBound != null || upperBound != window.getUpperBound() && upperBound != null) {
            return new RexWindow(clonedPartitionKeys, clonedOrderKeys, lowerBound, upperBound, window.isRows());
        }
        return window;
    }

    @Override
    public RexNode visitCall(RexCall call) {
        boolean[] update = new boolean[]{false};
        List<RexNode> clonedOperands = this.visitList(call.operands, update);
        if (update[0]) {
            return new RexCall(call.getType(), call.getOperator(), clonedOperands);
        }
        return call;
    }

    protected RexNode[] visitArray(RexNode[] exprs, boolean[] update) {
        RexNode[] clonedOperands = new RexNode[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            RexNode operand = exprs[i];
            RexNode clonedOperand = operand.accept(this);
            if (clonedOperand != operand && update != null) {
                update[0] = true;
            }
            clonedOperands[i] = clonedOperand;
        }
        return clonedOperands;
    }

    protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexNode rexNode : exprs) {
            RexNode clonedOperand = rexNode.accept(this);
            if (clonedOperand != rexNode && update != null) {
                update[0] = true;
            }
            clonedOperands.add(clonedOperand);
        }
        return clonedOperands.build();
    }

    public void visitList(List<? extends RexNode> exprs, List<RexNode> outExprs) {
        for (RexNode rexNode : exprs) {
            outExprs.add(rexNode.accept(this));
        }
    }

    protected List<RexFieldCollation> visitFieldCollations(List<RexFieldCollation> collations, boolean[] update) {
        ImmutableList.Builder clonedOperands = ImmutableList.builder();
        for (RexFieldCollation collation : collations) {
            RexNode clonedOperand = ((RexNode)collation.left).accept(this);
            if (clonedOperand != collation.left && update != null) {
                update[0] = true;
                collation = new RexFieldCollation(clonedOperand, (Set)collation.right);
            }
            clonedOperands.add(collation);
        }
        return clonedOperands.build();
    }

    @Override
    public RexNode visitCorrelVariable(RexCorrelVariable variable) {
        return variable;
    }

    @Override
    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        RexNode after;
        RexNode before = fieldAccess.getReferenceExpr();
        if (before == (after = before.accept(this))) {
            return fieldAccess;
        }
        return new RexFieldAccess(after, fieldAccess.getField());
    }

    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    @Override
    public RexNode visitLocalRef(RexLocalRef localRef) {
        return localRef;
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    @Override
    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return rangeRef;
    }

    public final <T extends RexNode> boolean mutate(List<T> exprList) {
        int changeCount = 0;
        for (int i = 0; i < exprList.size(); ++i) {
            RexNode expr2;
            RexNode expr = (RexNode)exprList.get(i);
            if (expr == (expr2 = this.apply(expr))) continue;
            ++changeCount;
            exprList.set(i, expr2);
        }
        return changeCount > 0;
    }

    public final <T extends RexNode> List<T> apply(List<T> exprList) {
        if (exprList == null) {
            return null;
        }
        ArrayList<T> list2 = new ArrayList<T>(exprList);
        if (this.mutate(list2)) {
            return list2;
        }
        return exprList;
    }

    public final Iterable<RexNode> apply(Iterable<? extends RexNode> iterable) {
        return Iterables.transform(iterable, new Function<RexNode, RexNode>(){

            @Override
            public RexNode apply(@Nullable RexNode t) {
                return t == null ? null : t.accept(RexShuttle.this);
            }
        });
    }

    public final RexNode apply(RexNode expr) {
        return expr == null ? null : expr.accept(this);
    }
}

